import QtQuick 2.3
import QtQuick.Layouts 1.2
import QtQuick.Controls 2.0
import elf_plugin 1.0
import "ViaviStyle"

Popup
{
    id: root

    width: parent.width
    height: parent.height

    background: Rectangle{

        anchors.fill: parent
        color: ViaviStyle.colors.transparentBackgroundColor

        Rectangle{
            id: contentWindow
            anchors.fill: parent
            anchors.margins: ViaviStyle.layouts.largeMargin
            color: ViaviStyle.colors.pageBackgroundColor
        }

        MouseArea{
            anchors.fill: parent
            onClicked: {
            }
        }
    }


    property int buttonsTabWidth : contentWindow.width / 10;
    property int tableCount : 3;
    property int tableWidth : (contentWindow.width - buttonsTabWidth - ViaviStyle.layouts.mediumMargin * tableCount) / tableCount;
    property int tableRows  : 10;

    property bool isTableFilterWindowEnabled : osaTableFilter_cfg_osaTableFilterEnabled.value
    readonly property int categoriesTableFocus : 0
    readonly property int availableTableFocus : 1
    readonly property int userDefinedTableFocus : 2
    property int lastFocusedTable : categoriesTableFocus

    Connections{
        target: functionsTabs_cfg_currentFunction
        function onValueChanged() {
            osaTableFilter_cfg_osaTableFilterEnabled.value = false
        }
    }

    Connections{
        target: status_res_otdrMode
        function onValueChanged() {
            osaTableFilter_cfg_osaTableFilterEnabled.value = false
        }
    }

    onIsTableFilterWindowEnabledChanged: {
        categoriesData.currentIndex = 0
        lastFocusedTable = categoriesTableFocus
    }

    //Column categories

    signal clicked(int row);
    onClicked: print('onClicked', row)

    //Categories

    Item {
        anchors.fill : parent

        Rectangle {
            id: categoriesHeader

            width: tableWidth;
            height: root.height / tableRows
            color: ViaviStyle.colors.activeColor

            Rectangle { // half height to cover bottom rounded corners
                width: tableWidth;  height: 0.5 * parent.height
                color: parent.color
                anchors.bottom: parent.bottom
            }
            Text {
                text: osaTableFilter_res_categoriesHeaderLabel.value
                anchors.fill: parent
                horizontalAlignment: Text.AlignHCenter
                verticalAlignment: Text.AlignVCenter
                font.pixelSize: 0.06 * tableWidth
                color: ViaviStyle.colors.activeItemTextColor
            }
        }


        ListView { // data
            id: categoriesData
            anchors{
                fill: parent;
                topMargin: categoriesHeader.height
                bottomMargin: ViaviStyle.layouts.mediumMargin
            }
            interactive: contentHeight > height
            boundsBehavior: Flickable.StopAtBounds
            clip: true
            model: osaTableFilter_res_categoriesModel.value
            currentIndex: 0
            spacing: ViaviStyle.layouts.borderSize

            delegate: Rectangle { // row

                width: tableWidth;  height: categoriesHeader.height
                opacity: 0.75
                color: ViaviStyle.colors.contentBackgroundColor

                property int     row:     index

                Row {
                    anchors.fill: parent

                    Item { // cell
                        width: tableWidth;  height: categoriesHeader.height

                        Text {
                            text: model.cellText
                            anchors.fill: parent
                            horizontalAlignment: Text.AlignHCenter
                            verticalAlignment: Text.AlignVCenter
                            font.pixelSize: 0.06 * tableWidth
                            color: ViaviStyle.colors.mainInfoColor
                        }
                    }
                }

                MouseArea {
                    id: mouseAreaCategories
                    anchors.fill: parent
                    onClicked:  {
                        categoriesData.currentIndex = index;
                        osaTableFilter_act_categoriesIndexChanged.invokeWithStringArg(row);
                        lastFocusedTable = categoriesTableFocus;
                    }
                }
            }

            highlight: Rectangle {
                color: lastFocusedTable === categoriesTableFocus ?
                           ViaviStyle.colors.selectedColor : ViaviStyle.colors.mainInfoColor

            }
            highlightMoveDuration: 1500

            focus: true

            ScrollBar{}
        }
    }


    //Available columns

    Item {
        anchors.fill : parent
        anchors.leftMargin: tableWidth + ViaviStyle.layouts.mediumMargin
        Rectangle {
            id: availableHeader

            width: tableWidth;
            height: root.height / tableRows
            color: ViaviStyle.colors.activeColor

            Rectangle { // half height to cover bottom rounded corners
                width: tableWidth;  height: 0.5 * parent.height
                color: parent.color
                anchors.bottom: parent.bottom
            }

            Text {
                text: osaTableFilter_res_availableHeaderLabel.value
                anchors.fill: parent
                horizontalAlignment: Text.AlignHCenter
                verticalAlignment: Text.AlignVCenter
                font.pixelSize: 0.06 * tableWidth
                color: ViaviStyle.colors.activeItemTextColor
            }
        }


        ListView { // data
            id: availableData
            anchors{
                fill: parent;
                topMargin: availableHeader.height
                bottomMargin: ViaviStyle.layouts.mediumMargin
            }
            interactive: contentHeight > height
            boundsBehavior: Flickable.StopAtBounds
            clip: true
            model: osaTableFilter_res_availableModel.value
            spacing: ViaviStyle.layouts.borderSize

            delegate: Rectangle { // row
                width: tableWidth;  height: availableHeader.height
                opacity: 0.75
                color: ViaviStyle.colors.contentBackgroundColor

                property int     row:     index

                Row {
                    anchors.fill: parent

                    Item { // cell
                        width: tableWidth;  height: availableHeader.height

                        Text {
                            text: model.cellText
                            anchors.fill: parent
                            horizontalAlignment: Text.AlignHCenter
                            verticalAlignment: Text.AlignVCenter
                            font.pixelSize: 0.06 * tableWidth
                            color: ViaviStyle.colors.mainInfoColor
                        }
                    }
                }

                MouseArea {
                    id: mouseAreaAvailable
                    anchors.fill: parent
                    onClicked:  {
                        availableData.currentIndex = index
                        osaTableFilter_act_availableIndexChanged.invokeWithStringArg(row)
                        lastFocusedTable = availableTableFocus;
                    }
                }
            }

            highlight: Rectangle {
                color: lastFocusedTable === availableTableFocus ?
                            ViaviStyle.colors.selectedColor : lastFocusedTable > availableTableFocus ?
                                           ViaviStyle.colors.mainInfoColor : ViaviStyle.colors.contentBackgroundColor
            }
            highlightMoveDuration: 1500
            focus: true

            ScrollBar{}
        }
    }

    //User defined

    Item {
        anchors.fill : parent
        anchors.leftMargin: 2 * (tableWidth + ViaviStyle.layouts.mediumMargin)
        Rectangle {
            id: userDefinedHeader

            width: tableWidth;
            height: root.height / tableRows
            color: ViaviStyle.colors.activeColor

            Rectangle { // half height to cover bottom rounded corners
                width: tableWidth;  height: 0.5 * parent.height
                color: parent.color
                anchors.bottom: parent.bottom
            }

            Text {
                text: osaTableFilter_cfg_userDefinedHeaderLabel.value
                anchors.fill: parent
                horizontalAlignment: Text.AlignHCenter
                verticalAlignment: Text.AlignVCenter
                font.pixelSize: 0.06 * tableWidth
                color: ViaviStyle.colors.activeItemTextColor
            }
        }


        ListView { // data
            id: userDefinedData
            anchors{
                fill: parent;
                topMargin: userDefinedHeader.height
                bottomMargin: ViaviStyle.layouts.mediumMargin
            }
            interactive: contentHeight > height
            boundsBehavior: Flickable.StopAtBounds
            clip: true
            model: osaTableFilter_res_userDefinedModel.value
            spacing: ViaviStyle.layouts.borderSize

            delegate: Rectangle { // row
                width: tableWidth;  height: userDefinedHeader.height
                opacity: 0.75
                color: ViaviStyle.colors.contentBackgroundColor

                property int     row:     index

                Row {
                    anchors.fill: parent

                    Item { // cell
                        width: tableWidth;  height: userDefinedHeader.height

                        Text {
                            text: model.cellText
                            anchors.fill: parent
                            horizontalAlignment: Text.AlignHCenter
                            verticalAlignment: Text.AlignVCenter
                            font.pixelSize: 0.06 * tableWidth
                            color: ViaviStyle.colors.mainInfoColor
                        }
                    }
                }

                MouseArea {
                    id: mouseAreaUserDefined
                    anchors.fill: parent
                    onClicked:  {
                        userDefinedData.currentIndex = index
                        osaTableFilter_act_userDefinedIndexChanged.invokeWithStringArg(row)
                        lastFocusedTable = userDefinedTableFocus;
                    }
                }
            }

            highlight: Rectangle {
                color: lastFocusedTable === userDefinedTableFocus ?
                            ViaviStyle.colors.selectedColor : lastFocusedTable > userDefinedTableFocus ?
                                           ViaviStyle.colors.mainInfoColor : ViaviStyle.colors.contentBackgroundColor
            }
            highlightMoveDuration: 1500
            focus: true

            ScrollBar{}
        }
    }



    ColumnLayout {
        anchors.fill: parent
        spacing: ViaviStyle.layouts.borderSize * 2

        WizardButton{
            id: upButtonId
            text: osaTableFilter_res_moveUpLabel.value
            enabled: lastFocusedTable === userDefinedTableFocus &&
                     userDefinedData.currentIndex - 1 >= 0

            Layout.alignment: Qt.AlignRight
            Layout.fillHeight: true
            width: buttonsTabWidth
            height: parent.height
            Layout.preferredWidth: buttonsTabWidth
            Layout.preferredHeight: parent.height

            onClicked:{
                var direction = -1;
                osaTableFilter_act_userDefinedMoveItem.invokeWithStringArg(direction);
                userDefinedData.currentIndex--;
            }
        }

        WizardButton{
            id: downButtonId
            text: osaTableFilter_res_moveDownLabel.value
            enabled: lastFocusedTable === userDefinedTableFocus &&
                     userDefinedData.currentIndex + 1 < userDefinedData.count

            Layout.alignment: Qt.AlignRight
            Layout.fillHeight: true
            width: buttonsTabWidth
            height: parent.height
            Layout.preferredWidth: buttonsTabWidth
            Layout.preferredHeight: parent.height

            onClicked:{
                var direction = 1;
                osaTableFilter_act_userDefinedMoveItem.invokeWithStringArg(direction);
                userDefinedData.currentIndex++;
            }
        }

        WizardButton{
            id: addToTableButtonId
            text: osaTableFilter_res_addLabel.value
            enabled: lastFocusedTable === availableTableFocus

            Layout.alignment: Qt.AlignRight
            Layout.fillHeight: true
            width: buttonsTabWidth
            height: parent.height
            Layout.preferredWidth: buttonsTabWidth
            Layout.preferredHeight: parent.height

            palette {
                button: ViaviStyle.colors.passColor
            }

            onClicked:{
                osaTableFilter_act_addToTable.invoke()
            }
        }

        WizardButton{
            id: removeFromTable
            text: osaTableFilter_res_removeLabel.value
            enabled: lastFocusedTable === userDefinedTableFocus

            Layout.alignment: Qt.AlignRight
            Layout.fillHeight: true
            width: buttonsTabWidth
            height: parent.height
            Layout.preferredWidth: buttonsTabWidth
            Layout.preferredHeight: parent.height

            palette {
                button: ViaviStyle.colors.failedColor
            }

            onClicked:{
                osaTableFilter_act_removeFromTable.invoke()
            }

        }

        WizardButton{
            id: closePage
            text: osaTableFilter_res_exitLabel.value

            Layout.alignment: Qt.AlignRight
            Layout.fillHeight: true
            width: buttonsTabWidth
            height: parent.height
            Layout.preferredWidth: buttonsTabWidth
            Layout.preferredHeight: parent.height

            onClicked:{
                osaTableFilter_cfg_osaTableFilterEnabled.value = false
            }
        }
    }



}

