import QtQuick 2.5
import QtQuick.Controls 2.0
import "ViaviStyle"

FiberListPopup{
    id: dwdmSelectionPopup

    property string comboboxId: ""

    titleText: numericdisplay_res_sourceDwdmTitle.value
    model: numericdisplay_res_choicesSource_1.value
    currentIndex: numericdisplay_res_selectionsSource_1.value

    Connections {
        target: numericdisplay_res_selectionsSource_1
        function onValueChanged() {
        	currentIndex = numericdisplay_res_selectionsSource_1.value
        }
    }

    delegate: FiberListDelegate{
        isSelected: dwdmSelectionPopup.currentIndex === model.choiceValue
        text: model.text
        onClicked: {
            dwdmSelectionPopup.comboboxId = model.comboboxId
            dwdmSelectionPopup.currentIndex = model.choiceValue
        }
    }


    onCancelClicked: {
        dwdmSelectionPopup.close()
        dwdmSelectionPopup.currentIndex = numericdisplay_res_selectionsSource_1.value
    }

    onValidateClicked: {
        numericdisplay_cfg_comboboxEvent.value = dwdmSelectionPopup.comboboxId + ':' + dwdmSelectionPopup.currentIndex
        dwdmSelectionPopup.close()
    }
}
