import QtQuick 2.5
import "ViaviStyle"

Rectangle {
    id: scrollIndicator
    property var scrollTarget: null
    property bool isUpIndicator: false

    implicitHeight: ViaviStyle.layouts.imageButtonHeight
    implicitWidth: ViaviStyle.layouts.imageButtonHeight

    height: implicitHeight
    width: implicitWidth

    color: "transparent"

    rotation: scrollIndicator.isUpIndicator ? 180: 0

    Rectangle {
        id: mask
        anchors.fill: parent
        gradient: Gradient {
            GradientStop { position: 0.0; color: ViaviStyle.colors.menuSelectionColor}
            GradientStop { position: 0.5; color: ViaviStyle.colors.contentBackgroundColor}
            GradientStop { position: 1.0; color: ViaviStyle.colors.menuSelectionColor }
        }
    }

    FiberColorImage {

        width: parent.width
        height: parent.height

        color: ViaviStyle.colors.mainInfoColor

        source: ViaviStyle.images.iconMenu3Dots
        fillMode: Image.PreserveAspectFit
    }

    MouseArea {
        id: mouseArea
        anchors.fill: parent

        SmoothedAnimation {
            target: scrollTarget
            property: 'contentY'
            running: mouseArea.pressed
            velocity: platform.screenHeight / 5
            to: isUpIndicator || !scrollTarget ? 0 : scrollTarget.childrenRect.height
        }
    }
}



