﻿import QtQuick 2.3
import QtQuick.Controls 2.0
import elf_plugin 1.0

import QtQuick.Layouts 1.2

import "ViaviStyle"

RowLayout {
    id: rootId

    spacing: ViaviStyle.layouts.isSmallScreen ?
                 ViaviStyle.layouts.veryLargeMargin * 2 : ViaviStyle.layouts.veryLargeMargin

    CheckTextButton{
        Layout.fillHeight: true

        enabled: status_res_otdrCableCoEnabled.value ? cable_res_viewTestEnabled.value : true

        checked: !status_res_traceEnabled.value
                 && !status_res_eventsTableEnabled.value
                 && !status_res_otdrCableCoEnabled.value

        text: schematic_res_viewLabel.value

        mouseArea.onClicked: {
            status_act_switchToSLM.invoke()
        }
    }

    CheckTextButton {
        id: traceTabButton
        Layout.fillHeight: true

        enabled: status_res_otdrCableCoEnabled.value ? cable_res_viewTestEnabled.value : true
        checked: status_res_traceEnabled.value

        text: trace_res_viewLabel.value

        mouseArea.onClicked: {
            status_act_switchToTrace.invoke()
        }
    }

    CheckTextButton{
        Layout.fillHeight: true

        checked: status_res_eventsTableEnabled.value
        enabled: status_res_resultsTableAvailable.value

        text: events_res_viewLabel.value

        mouseArea.onClicked: {
            status_act_switchToTable.invoke()
        }
    }

    CheckTextButton{
        Layout.fillHeight: true

        checked: status_res_otdrCableCoEnabled.value
        enabled: cable_res_viewButtonEnabled.value && !status_res_otdrCableCoEnabled.value

        text: cable_res_viewButtonLabel.value

        mouseArea.onClicked: {
            status_act_switchToCable.invoke()
        }

        visible: cable_res_viewButtonEnabled.value
    }

    Item {
        id: spacer
        Layout.fillWidth: true
    }

    ThreeStateButtonOption {
        id: threeStateButton

        visible: !status_res_otdrCableCoEnabled.value
        hasMiddleState: traceTabButton.checked
        isRightDataVisible: bargraph_res_isFiberDataVisible.value

        Layout.fillHeight: true

        leftText: schematic_res_miniSLMLabel.value
        rightText: trace_res_miniTraceLabel.value

        button.onLeftStateActive: status_cfg_topPanelState.value = status_cfg_topPanelState.enums.ecCustomPanel

        button.onMiddleStateActive: status_cfg_topPanelState.value = status_cfg_topPanelState.enums.ecNoPanel

        button.onRightStateActive: status_cfg_topPanelState.value = status_cfg_topPanelState.enums.ecSummaryPanel

	    Connections{
	        target: status_cfg_topPanelState
	        function onValueChanged() {
                switch(status_cfg_topPanelState.value){
                case status_cfg_topPanelState.enums.ecNoPanel:
	            	threeStateButton.button.buttonState = threeStateButtonbutton.button.middleActiveState
                    break;
	            case status_cfg_topPanelState.enums.ecSummaryPanel:
                    threeStateButton.button.buttonState = threeStateButton.button.rightActiveState
                    break;
	            default:
                    threeStateButton.button.buttonState = threeStateButton.button.leftActiveState
                    break;
	            }
	        }
	    }
	    
        //set the initial value, the binding will be broken the first time the user changes it from UI
        button.buttonState: {
            switch(status_cfg_topPanelState.value){
            case status_cfg_topPanelState.enums.ecNoPanel:
                return button.middleActiveState
            case status_cfg_topPanelState.enums.ecSummaryPanel:
                return button.rightActiveState
            default:
                return button.leftActiveState
            }
        }
    }
}
