﻿import QtQuick 2.3
import QtQuick.Controls 2.0
import elf_plugin 1.0

import QtQuick.Layouts 1.2

import "ViaviStyle"

Row {
    id: rootId

    spacing: ViaviStyle.layouts.isSmallScreen ?
                 ViaviStyle.layouts.veryLargeMargin * 2 : ViaviStyle.layouts.veryLargeMargin

    CheckTextButton{
        height: parent.height

        visible: multigraphsStates_res_isOdmDelayAvailable.value
        checked: multigraphsStates_res_isOdmDelayActive.value

        text: multigraphsStates_res_delayLabel.value

        mouseArea.onClicked: multigraphsStates_act_switchToOdmDelay.invoke()
    }

    CheckTextButton {
        id: traceTabButton
        height: parent.height

        visible: multigraphsStates_res_isOdmDispersionAvailable.value
        checked: multigraphsStates_res_isOdmDispersionActive.value

        text: multigraphsStates_res_dispersionLabel.value

        mouseArea.onClicked: multigraphsStates_act_switchToOdmDispersion.invoke()
    }

    CheckTextButton{
        height: parent.height

        visible: multigraphsStates_res_isOdmSlopeAvailable.value
        checked: multigraphsStates_res_isOdmSlopeActive.value

        text: multigraphsStates_res_slopeLabel.value

        mouseArea.onClicked: multigraphsStates_act_switchToOdmSlope.invoke()
    }

    CheckTextButton{
        height: parent.height

        visible: multigraphsStates_res_isOdmPhaseAvailable.value
        checked: multigraphsStates_res_isOdmPhaseActive.value

        text: multigraphsStates_res_phaseLabel.value

        mouseArea.onClicked: multigraphsStates_act_switchToOdmPhase.invoke()
    }
}
