import QtQuick 2.3

Rectangle {
	id: pinCode
	
	property int bw: 80
	property int bh: (pinCode.height / 4) - 25

	Image {
		width: parent.width
		height: parent.height
		source: Pin.background
	}

	Text {
		id: lbl
		anchors.top: parent.top
		width: parent.width
		height: 56 // allow for 2 lines in title 

		verticalAlignment: Text.AlignVCenter
		horizontalAlignment: Text.AlignHCenter

		font.family: "DejaVu LGC SansCondensed"
		font.bold: false
		font.pointSize: 16

		text: Pin.label
	}

	Rectangle {
		id: inputBox
		anchors.top: lbl.bottom
		color: "white"

		width: parent.width - (x * 2)
		height: 25
		x : 25

		border.color: "red"
		border.width: 1

		TextInput {
			id: inpBox
			color: "black"
			anchors.fill: parent

			font.family: "DejaVu LGC SansCondensed"
			font.bold: false
			font.pointSize: 16
			focus: true

			cursorVisible: true

			echoMode: TextInput.PasswordEchoOnEdit
			text: Pin.result
		}
	}

	Rectangle {
		width: parent.width
		height: parent.height - lbl.height - inputBox.height - 15
		anchors.top: inputBox.bottom
		color: "transparent"
		
		Grid {
			columns: 4
			spacing: 0
			rows: 4
			
			anchors.top: parent.top
			anchors.horizontalCenter : parent.horizontalCenter
			anchors.verticalCenter : parent.verticalCenter
			
			Isu_Pincode_Button { width: bw; height: bh; iBox: inpBox; text: "1" }
			Isu_Pincode_Button { width: bw; height: bh; iBox: inpBox; text: "2" }
			Isu_Pincode_Button { width: bw; height: bh; iBox: inpBox; text: "3" }
			Isu_Pincode_Button { width: bw; height: bh; iBox: inpBox; text: "Back" }
			Isu_Pincode_Button { width: bw; height: bh; iBox: inpBox; text: "4" }
			Isu_Pincode_Button { width: bw; height: bh; iBox: inpBox; text: "5" }
			Isu_Pincode_Button { width: bw; height: bh; iBox: inpBox; text: "6" }
			Isu_Pincode_Button { width: bw; height: bh; iBox: inpBox; text: "hidden" }
			Isu_Pincode_Button { width: bw; height: bh; iBox: inpBox; text: "7" }
			Isu_Pincode_Button { width: bw; height: bh; iBox: inpBox; text: "8" }
			Isu_Pincode_Button { width: bw; height: bh; iBox: inpBox; text: "9" }
			Isu_Pincode_Button { width: bw; height: bh; iBox: inpBox; text: "hidden" }
			Isu_Pincode_Button { width: bw; height: bh; iBox: inpBox; text: "0" }
			Isu_Pincode_Button { width: bw; height: bh; iBox: inpBox; text: "hidden" }
			Isu_Pincode_Button { width: bw; height: bh; iBox: inpBox; text: "hidden" }
			Isu_Pincode_Button { width: bw; height: bh; iBox: inpBox; text: "Enter" }
		}
	}
}
