import QtQuick 2.3
import QtQuick.Layouts 1.2
import QtQuick.Controls 2.0
import "ViaviStyle"

AbstractButton{
    id: button

    property alias textHorizontalAlignment: textId.horizontalAlignment

    height: ViaviStyle.layouts.buttonHeight
    contentItem:
    Rectangle{
        color: button.pressed ? ViaviStyle.colors.selectedColor : "transparent"

        ColumnLayout{
            id: mainArea
            anchors.fill: parent
            anchors.topMargin: ViaviStyle.layouts.smallMargin
            anchors.bottomMargin: ViaviStyle.layouts.smallMargin
            anchors.leftMargin: ViaviStyle.layouts.mediumMargin
            anchors.rightMargin: ViaviStyle.layouts.mediumMargin

            Text{
                id: textId

                Layout.fillWidth: true
                Layout.fillHeight: true

                horizontalAlignment: Text.AlignHCenter
                verticalAlignment: Text.AlignVCenter

                text: button.text
                font: button.font
            }

            Item{
                height: ViaviStyle.layouts.smallMargin - separatorId.height
            }

            Rectangle{
                id: separatorId

                Layout.fillWidth: true
                height: ViaviStyle.layouts.separatorSize

                color: ViaviStyle.colors.activeColor
            }
        }
    }
}
