import QtQuick 2.3
import QtQuick.Controls 2.0
import QtQuick.Templates 2.0 as T
import "ViaviStyle"

ComboBox {
    id: root

    implicitHeight: ViaviStyle.layouts.buttonHeight
    implicitWidth: height * 4

    height: implicitHeight
    width: implicitWidth

    padding: ViaviStyle.layouts.smallMargin

    background: Rectangle{
        width: root.width
        height: root.height

        color: root.pressed ? ViaviStyle.colors.pageBackgroundColor : ViaviStyle.colors.borderColor
    }

    contentItem: Text {
        text: root.displayText

        width: root.width
        height: root.height
        x: ViaviStyle.layouts.smallMargin

        verticalAlignment: Text.AlignVCenter

        font: ViaviStyle.layouts.activeBoldTextFont

        color: ViaviStyle.colors.activeColor
    }

    delegate: ItemDelegate {
        id: delegateItem
        height: ViaviStyle.layouts.menuLineHeight
        width: root.width
        contentItem: Text{
            anchors.horizontalCenter: parent.horizontalCenter
            x: ViaviStyle.layouts.smallMargin

            verticalAlignment: Text.AlignVCenter

            text: model.text
            font: ViaviStyle.layouts.activeBoldTextFont

            color: ViaviStyle.colors.mainInfoColor
        }

        background: Rectangle{
            anchors.fill: parent

            color: delegateItem.pressed ? ViaviStyle.colors.pageBackgroundColor : ViaviStyle.colors.contentBackgroundColor
        }
    }

    indicator: Item{
        width: root.width
        height: root.height

        Image {
            id: selectionMarker

            width: ViaviStyle.layouts.largeMargin
            height: ViaviStyle.layouts.largeMargin

            anchors.right: parent.right
            anchors.rightMargin: ViaviStyle.layouts.smallMargin
            anchors.verticalCenter: parent.verticalCenter

            source: ViaviStyle.images.iconMenuArrow
            fillMode: Image.PreserveAspectFit
            transform: Rotation{
                origin.x: selectionMarker.width / 2
                origin.y: selectionMarker.height / 2
                angle: popup.visible ? 90 : -90
            }

            smooth: true
        }
    }

    popup: Popup {
        y: root.height
        width: root.width
        implicitHeight: contentItem.implicitHeight + padding * 2
        padding: ViaviStyle.layouts.borderSmallWidth

        contentItem: ListView {
            clip: true
            implicitHeight: contentHeight
            model: root.popup.visible ? root.delegateModel : null
            delegate: root.delegate
            currentIndex: root.highlightedIndex
        }
    }
}
