import QtQuick 2.5
import QtQuick.Controls 2.0
import QtQuick.Layouts 1.3
import 'ViaviStyle'

FiberPopup {
    id: eventTypePopup
    FiberToolButton {
        id: spliceButton
        text:eventscontrol_res_spliceLabel.value
        onClicked: {
            eventscontrol_act_eventCodeSplice.invoke()
        }
    }
    FiberToolButton {
        id: connectorButton
        text: eventscontrol_res_connectorLabel.value
        onClicked: {
            eventscontrol_act_eventCodeConnector.invoke()
        }
    }
    FiberToolButton {
        id: balancedSplitterButton
        text: eventscontrol_res_splitterBalancedLabel.value

        onClicked: {
            balancedPopup.open()
        }

        FiberListPopup {
            id: balancedPopup
            titleText: eventscontrol_res_splitterBalancedLabel.value
            margins: 0
            height: overlayReplacer.height
            width: overlayReplacer.width

            model: eventscontrol_res_balancedSplitterTypes.value
            currentIndex: -1
            property int codeValue: -1


            delegate: FiberListDelegateWithImage {
                width: parent.width
                
                text: model.label
                iconPath: model.iconPath
                isSelected: balancedPopup.currentIndex === model.index

                onClicked: {
                    balancedPopup.currentIndex = model.index
                    balancedPopup.codeValue = model.codeValue
                }
            }

            onCancelClicked: {
                balancedPopup.close()
            }

            onValidateClicked: {
                if (codeValue !== -1) {
                    eventscontrol_act_setSplitterTypeCode.invokeWithStringArg(codeValue)
                }
                balancedPopup.close()
            }
        }
    }

    FiberToolButton {
        id: unbalancedSplitterButton
        text: eventscontrol_res_couplerUnbalancedLabel.value

        onClicked: {
            unbalancedPopup.open()
        }

        FiberListPopup {
            id: unbalancedPopup
            titleText: eventscontrol_res_couplerUnbalancedLabel.value
            margins: 0
            height: overlayReplacer.height
            width: overlayReplacer.width

            model: eventscontrol_res_unbalancedSplitterTypes.value
            currentIndex: -1
            property int codeValue: -1

            delegate: FiberListDelegateWithImage {
                width: parent.width
                
                text: model.label
                iconPath: model.iconPath
                isSelected: unbalancedPopup.currentIndex === model.index

                onClicked: {
                    unbalancedPopup.currentIndex = model.index
                    unbalancedPopup.codeValue = model.codeValue
                }
            }

            onCancelClicked: {
                unbalancedPopup.close()
            }

            onValidateClicked: {
                if (codeValue !== -1) {
                    eventscontrol_act_setSplitterTypeCode.invokeWithStringArg(codeValue)
                }
                unbalancedPopup.close()
            }
        }
    }

    FiberToolButton {
        id: ghostButton
        text: eventscontrol_res_ghostLabel.value
        onClicked: {
            eventscontrol_act_eventCodeGhost.invoke()
        }
    }
    
    FiberToolButton {
        id: muxDemuxButton
        text: eventscontrol_res_muxDemuxLabel.value
        visible: eventscontrol_res_muxDemuxButtonVisible.value
        onClicked: {
            eventscontrol_act_eventCodeMuxDemux.invoke()
        }
    }
    
    FiberToolButton {
        id: expendedBeamButton
        text: eventscontrol_res_expendedBeamLabel.value
        visible: eventscontrol_res_eBConnectorButtonVisible.value
        onClicked: {
            eventscontrol_act_eventCodeExpendedBeam.invoke()
        }
    }
    
    
    FiberToolButton {
        id: fiberEndButton
        text: eventscontrol_res_fiberEndLabel.value
        onClicked: {
            eventscontrol_act_eventCodeFiberEnd.invoke()
        }

    }
}
