import QtQuick 2.7
import QtQuick.Controls 2.0

import "ViaviStyle"

import elf_plugin 1.0


Rectangle {
    id: root

    color: ViaviStyle.colors.pageBackgroundColor

    FiberContainer{
        id: topInfoArea
        anchors.top: parent.top
        anchors.left: parent.left
        anchors.right: parent.right

        height: ViaviStyle.layouts.buttonHeight * 2

        anchors.leftMargin : ViaviStyle.layouts.largeMargin
        anchors.rightMargin : ViaviStyle.layouts.largeMargin

        anchors.topMargin : ViaviStyle.layouts.mediumMargin
        anchors.bottomMargin : ViaviStyle.layouts.mediumMargin

        Rectangle{
            id: imageContainer
            anchors.top: parent.top
            anchors.left: parent.left
            anchors.bottom: parent.bottom
            width: 2 * height

            color: "transparent"

            border.color: ViaviStyle.colors.activeColor
            border.width: ViaviStyle.layouts.smallMargin

            FiberContainer{
                anchors.fill: parent
                anchors.margins: parent.border.width

                Image{
                    id: smallImage
                    anchors.fill: parent
                    anchors.margins: ViaviStyle.layouts.borderSize

                    cache: false

                    property ElfData changeFlag: dtsBattery_cfg_variationModeOn.value
                                                 ? dtsBattery_res_heatMapChangeFlag
                                                   : dtsBattery_res_variationMapChangeFlag
                    property ElfData mapPath: dtsBattery_cfg_variationModeOn.value
                                                ? dtsBattery_res_heatMapImgPath
                                                       : dtsBattery_res_variationMapImgPath
                    onMapPathChanged: {
                        smallImage.source = ""
                        smallImage.source = smallImage.mapPath.value
                    }

                    Connections{
                        target: smallImage.changeFlag
                        function onValueChanged() {
                            smallImage.source = ""
                            smallImage.source = smallImage.mapPath.value
                        }
                    }
                }
            }

            MouseArea{
                anchors.fill: parent

                onClicked: dtsBattery_cfg_variationModeOn.value = !dtsBattery_cfg_variationModeOn.value
            }
        }

        Text{
            anchors.left: imageContainer.right
            anchors.top:  parent.top

            anchors.margins: ViaviStyle.layouts.smallMargin

            font: ViaviStyle.layouts.smallFont

            text: dtsBattery_cfg_variationModeOn.value
                  ? dtsBattery_res_heatMapLabel.value
                    : dtsBattery_res_variationMapLabel.value
        }

        Text{
            anchors.left: imageContainer.right
            anchors.right: parent.right
            anchors.bottom: parent.bottom

            anchors.margins: ViaviStyle.layouts.smallMargin

            font: ViaviStyle.layouts.smallFont

            horizontalAlignment: Text.AlignHCenter

            text: dtsBattery_cfg_variationModeOn.value
                  ? dtsBattery_res_variationMapLabel.value
                    : dtsBattery_res_heatMapLabel.value
        }

        Item{
            anchors.fill: parent

            visible: dtsBattery_res_acqInProgress.value

            InprogressIcon{
                id: icon
                anchors.right: parent.right
                anchors.top: parent.top

                anchors.margins: ViaviStyle.layouts.smallMargin
            }

            Text{
                anchors.right: icon.left
                anchors.top: parent.top


                anchors.margins: ViaviStyle.layouts.largeMargin

                font: ViaviStyle.layouts.largeBoldFont

                horizontalAlignment: Text.AlignRight

                text: dtsBattery_res_monitoringLabel.value
            }
        }
    }

    FiberContainer{
        id: container
        anchors.top: topInfoArea.bottom
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.bottom: parent.bottom

        anchors.leftMargin : ViaviStyle.layouts.largeMargin
        anchors.rightMargin : ViaviStyle.layouts.largeMargin

        anchors.topMargin : ViaviStyle.layouts.mediumMargin
        anchors.bottomMargin : ViaviStyle.layouts.mediumMargin

        SequentialAnimation {
            id: animation
            PropertyAnimation  {
                target: container
                property: "color"
                to: "yellow"
                duration: 750
            }
            PropertyAnimation  {
                target: container
                property: "color"
                to: ViaviStyle.colors.contentBackgroundColor
                duration: 750
            }
        }

        Connections{
            target: dtsBattery_res_updateScanFlag
            function onValueChanged() {
                animation.start()
            }
        }

        Rectangle{
            id: heatMapBorder

            anchors.rightMargin :2 *  ViaviStyle.layouts.largeMargin
            anchors.leftMargin :2 *  ViaviStyle.layouts.largeMargin

            anchors.topMargin : 2 * ViaviStyle.layouts.largeMargin
            anchors.bottomMargin : 2 * ViaviStyle.layouts.largeMargin

            anchors.top: parent.top
            anchors.bottom: parent.bottom
            anchors.right: legend.left
            anchors.left: parent.left

            color: "transparent"

            border.color : ViaviStyle.colors.borderColor
            border.width: ViaviStyle.layouts.borderSize

            Image{
                id: image
                anchors.fill: parent
                anchors.margins: parent.border.width

                cache: false

                property ElfData changeFlag: dtsBattery_cfg_variationModeOn.value
                                             ? dtsBattery_res_variationMapChangeFlag
                                               : dtsBattery_res_heatMapChangeFlag
                property ElfData mapPath: dtsBattery_cfg_variationModeOn.value
                                            ? dtsBattery_res_variationMapImgPath
                                                   : dtsBattery_res_heatMapImgPath


                onMapPathChanged: {
                    image.source = ""
                    image.source = smallImage.mapPath.value
                }

                Connections{
                    target: image.changeFlag
                    function onValueChanged() {
                        image.source = ""
                        image.source = image.mapPath.value
                    }
                }

                Repeater{
                    model: dtsBattery_cfg_nbOfColumns.value

                    Rectangle{
                        anchors.top: parent.top
                        anchors.bottom: parent.bottom

                        anchors.topMargin: - ViaviStyle.layouts.largeMargin
                        anchors.bottomMargin: - ViaviStyle.layouts.largeMargin

                        width: ViaviStyle.layouts.borderSize

                        color: ViaviStyle.colors.borderColor

                        x: ((2 * model.index + 1 ) / (2 * dtsBattery_cfg_nbOfColumns.value)) * parent.width
                    }
                }

                Repeater{
                    model: dtsBattery_cfg_nbOfRows.value

                    Rectangle{
                        anchors.left: parent.left
                        anchors.right: parent.right

                        anchors.leftMargin: - ViaviStyle.layouts.largeMargin
                        anchors.rightMargin: - ViaviStyle.layouts.largeMargin

                        height: ViaviStyle.layouts.borderSize

                        color: ViaviStyle.colors.borderColor

                        y: ((2 * model.index + 1) / (2 * dtsBattery_cfg_nbOfRows.value )) * parent.height
                    }
                }
            }
        }

        Item{
            id: unitText
            anchors.topMargin : 2 * ViaviStyle.layouts.mediumMargin

            anchors.top: parent.top
            anchors.right: legend.right
            anchors.left: legend.left

            height: unitLabel.height

            Text{
                id: unitLabel

                width: contentWidth
                height: contentHeight

                anchors.verticalCenter: parent.verticalCenter
                anchors.right: parent.right

                text: dtsBattery_cfg_variationModeOn.value
                        ? dtsBattery_res_temperatureUnitLabel.value + "/" + dtsBattery_res_minuteUnitLabel.value
                        : dtsBattery_res_temperatureUnitLabel.value
            }
        }


        HeatMapLegend{
            id: legend

            anchors.rightMargin :2 *  ViaviStyle.layouts.mediumMargin

            anchors.topMargin : 2 * ViaviStyle.layouts.mediumMargin
            anchors.bottomMargin : 2 * ViaviStyle.layouts.mediumMargin

            anchors.top: unitText.bottom
            anchors.bottom: parent.bottom
            anchors.right: parent.right

            colorIntensity:  dtsBattery_cfg_colorIntensity.value / 255.0

            minValue: dtsBattery_cfg_variationModeOn.value ? dtsBattery_cfg_minVariation.value * 60.0 : dtsBattery_cfg_minTemp.value
            maxValue: dtsBattery_cfg_variationModeOn.value ? dtsBattery_cfg_maxVariation.value * 60.0 : dtsBattery_cfg_maxTemp.value
            labelNrOfDecimals: dtsBattery_cfg_variationModeOn.value ? 0 : 0
        }
    }
}
