import QtQuick 2.5
import QtQuick.Controls 2.0
import QtQuick.Layouts 1.2
import elf_plugin 1.0

import "ViaviStyle"

Item {
    id: root

    anchors.fill: parent

    property double colorIntensity: dtsBattery_cfg_colorIntensity.value / 255.0

    function getColor(temperature){
        if(temperature < dtsBattery_cfg_minTemp.value){
            return Qt.rgba(0,0, colorIntensity, 1.0)
        }
        if(temperature > dtsBattery_cfg_maxTemp.value){
            return Qt.rgba(colorIntensity,0, 0, 1.0)
        }
        var sector = (dtsBattery_cfg_maxTemp.value - dtsBattery_cfg_minTemp.value) / 4
        var base = dtsBattery_cfg_maxTemp.value - sector
        if(temperature >= base){

            return Qt.rgba(colorIntensity, (1.0 - (temperature - base) / sector) * colorIntensity, 0, 1.0)
        }
        base = dtsBattery_cfg_maxTemp.value - 2 * sector
        if(temperature >= base){
            return Qt.rgba((temperature - base) / sector * colorIntensity, colorIntensity, 0, 1.0)
        }

        base = dtsBattery_cfg_maxTemp.value - 3 * sector
        if(temperature >= base){
            return Qt.rgba(0, colorIntensity, (1.0 - (temperature - base) / sector) * colorIntensity, 1.0)
        }

        return Qt.rgba(0, (temperature - dtsBattery_cfg_minTemp.value) / sector * colorIntensity, colorIntensity, 1.0)
    }

    FiberPopup {
        id:     tablePopup

        FiberToolButton {
            text: "Fill row next"
            elfAction: dtsBattery_act_fillRowNext
        }
        FiberToolButton {
            text: "Fill row all"
            elfAction: dtsBattery_act_fillRowAll
        }
        FiberToolButton {
            text: "Fill row prev"
            elfAction: dtsBattery_act_fillRowPrev
        }
        FiberToolButton {
            text: "Fill all next"
            elfAction: dtsBattery_act_fillAllNext
        }
        FiberToolButton {
            text: "Fill all"
            elfAction: dtsBattery_act_fillAll
        }
        FiberToolButton {
            text: "Fill all prev"
            elfAction: dtsBattery_act_fillAllPrev
        }
    }

    FiberContainer{
        id: container

        anchors.fill: parent

        anchors.leftMargin : ViaviStyle.layouts.largeMargin
        anchors.rightMargin : ViaviStyle.layouts.largeMargin

        anchors.topMargin : ViaviStyle.layouts.mediumMargin
        anchors.bottomMargin : ViaviStyle.layouts.mediumMargin


        KeyboardUtils { id: keyboardUtils }

        Popup{
            id: keyboardPopup

            width: fiberMainPage.width
            height: fiberMainPage.height

            //property var translatedPosition: container.mapFromItem(fiberMainPage, 0, 0)
            x: 0
            y: 0
            parent: fiberMainPage

            modal: true

            closePolicy: Popup.NoAutoClose

            background: Rectangle{

                anchors.fill: parent

                color: ViaviStyle.colors.transparentBackgroundColor
            }

            contentItem: Item{

                anchors.fill: parent

                KeyboardNumerical{
                    id: keyboard
                    //   visible: false
                    property ElfData currentKeyboardElf

                    onAccepted: {
                        if(currentKeyboardElf){
                            currentKeyboardElf.value = textField
                        }

                        keyboardPopup.close()
                    }

                    onCanceled: keyboardPopup.close()

                }
            }
        }

        Popup{
            id: keyboardAlphaPopup

            width: fiberMainPage.width
            height: fiberMainPage.height

            property alias textField: keyboardAlpha.textField
            property alias initialText: keyboardAlpha.initialText

            //property var translatedPosition: container.mapFromItem(fiberMainPage, 0, 0)
            x: 0
            y: 0
            parent: fiberMainPage

            modal: true

            closePolicy: Popup.NoAutoClose

            background: Rectangle{

                anchors.fill: parent

                color: ViaviStyle.colors.transparentBackgroundColor
            }

            signal accepted()
            signal canceled()

            contentItem: Item{

                anchors.fill: parent

                KeyboardAlpha{
                    id: keyboardAlpha

                    inputTextMaxLength: 60
                    onAccepted: keyboardAlphaPopup.accepted()
                    onCanceled: keyboardAlphaPopup.canceled()


                }
            }
        }

        Flickable{
            anchors.fill: parent
            contentHeight: column.height

            boundsBehavior: Flickable.StopAtBounds
            Column {
                id: column

                anchors.left: parent.left
                anchors.right: parent.right

                anchors.leftMargin : ViaviStyle.layouts.mediumMargin
                anchors.rightMargin : ViaviStyle.layouts.mediumMargin

                anchors.topMargin : ViaviStyle.layouts.mediumMargin
                anchors.bottomMargin : ViaviStyle.layouts.mediumMargin

                spacing: 15

                Row{spacing:10
                    Text{
                        anchors.bottom: parent.bottom
                        verticalAlignment: Text.Bottom

                        font: ViaviStyle.layouts.largeBoldFont

                        text: "Rows: "
                    }

                    FiberEditableText{
                        id: nbOfRowsEdit
                        font: ViaviStyle.layouts.tableFont
                        width: 70
                        textHorizontalAlignment: Text.AlignHCenter

                        height: ViaviStyle.layouts.menuLineHeight

                        onClicked: {
                            keyboard.currentKeyboardElf = dtsBattery_cfg_nbOfRows
                            keyboard.initialText = dtsBattery_cfg_nbOfRows.value
                            keyboardPopup.open()
                        }

                        Connections{
                            target: dtsBattery_cfg_nbOfRows
                            function onValueChanged() {
                                nbOfRowsEdit.text = dtsBattery_cfg_nbOfRows.value
                            }
                        }

                        Component.onCompleted: nbOfRowsEdit.text = dtsBattery_cfg_nbOfRows.value
                    }

                    Text{
                        anchors.bottom: parent.bottom
                        verticalAlignment: Text.Bottom

                        font: ViaviStyle.layouts.largeBoldFont
                        text: "Elements/row: "
                    }

                    FiberEditableText{
                        id: nbOfColumnsEdit
                        font: ViaviStyle.layouts.tableFont
                        width: 70
                        textHorizontalAlignment: Text.AlignHCenter

                        height: ViaviStyle.layouts.menuLineHeight

                        onClicked: {
                            keyboard.currentKeyboardElf = dtsBattery_cfg_nbOfColumns
                            keyboard.initialText = dtsBattery_cfg_nbOfColumns.value
                            keyboardPopup.open()
                        }

                        Connections{
                            target: dtsBattery_cfg_nbOfColumns
                            function onValueChanged() {
                                nbOfColumnsEdit.text = dtsBattery_cfg_nbOfColumns.value
                            }
                        }

                        Component.onCompleted: nbOfColumnsEdit.text = dtsBattery_cfg_nbOfColumns.value
                    }

                    Text{
                        anchors.bottom: parent.bottom
                        verticalAlignment: Text.Bottom

                        font: ViaviStyle.layouts.largeBoldFont

                        text: "Spirals/element: "
                    }

                    FiberEditableText{
                        font: ViaviStyle.layouts.tableFont
                        width: 70
                        textHorizontalAlignment: Text.AlignHCenter
                        text: dtsBattery_cfg_nbOfSpiralsPerElement.value

                        height: ViaviStyle.layouts.menuLineHeight

                        onClicked: {
                            keyboard.currentKeyboardElf = dtsBattery_cfg_nbOfSpiralsPerElement
                            keyboard.initialText = dtsBattery_cfg_nbOfSpiralsPerElement.value
                            keyboardPopup.open()
                        }
                    }

                }

                Row{spacing:10
                    Text{
                        anchors.bottom: parent.bottom
                        verticalAlignment: Text.Bottom

                        font: ViaviStyle.layouts.largeBoldFont

                        text: "Spiral diameter: "
                    }

                    FiberEditableText{
                        font: ViaviStyle.layouts.tableFont
                        width: 100
                        textHorizontalAlignment: Text.AlignHCenter
                        text: dtsBattery_cfg_spiralDiameter.value.toFixed(8)

                        height: ViaviStyle.layouts.menuLineHeight

                        onClicked: {
                            keyboard.currentKeyboardElf = dtsBattery_cfg_spiralDiameter
                            keyboard.initialText = dtsBattery_cfg_spiralDiameter.value
                            keyboardPopup.open()
                        }
                    }

                    Text{
                        anchors.bottom: parent.bottom
                        verticalAlignment: Text.Bottom

                        font: ViaviStyle.layouts.largeBoldFont

                        text: "Elements distance: "
                    }

                    FiberEditableText{
                        font: ViaviStyle.layouts.tableFont
                        width: 100
                        textHorizontalAlignment: Text.AlignHCenter
                        text: dtsBattery_cfg_elementsDistance.value.toFixed(8)

                        height: ViaviStyle.layouts.menuLineHeight

                        onClicked: {
                            keyboard.currentKeyboardElf = dtsBattery_cfg_elementsDistance
                            keyboard.initialText = dtsBattery_cfg_elementsDistance.value
                            keyboardPopup.open()
                        }
                    }

                }

                Row{spacing:10
                    Text{
                        anchors.bottom: parent.bottom
                        verticalAlignment: Text.Bottom

                        font: ViaviStyle.layouts.largeBoldFont

                        text: "Rows distance: "
                    }

                    FiberEditableText{
                        font: ViaviStyle.layouts.tableFont
                        width: 100
                        textHorizontalAlignment: Text.AlignHCenter
                        text: dtsBattery_cfg_rowsDistance.value.toFixed(8)

                        height: ViaviStyle.layouts.menuLineHeight

                        onClicked: {
                            keyboard.currentKeyboardElf = dtsBattery_cfg_rowsDistance
                            keyboard.initialText = dtsBattery_cfg_rowsDistance.value
                            keyboardPopup.open()
                        }
                    }

                    Text{
                        anchors.bottom: parent.bottom
                        verticalAlignment: Text.Bottom

                        font: ViaviStyle.layouts.largeBoldFont

                        text: "Start offset: "
                    }

                    FiberEditableText{
                        font: ViaviStyle.layouts.tableFont
                        width: 100
                        textHorizontalAlignment: Text.AlignHCenter
                        text: dtsBattery_cfg_imgStartOffsetDisplay.value.toFixed(8)

                        height: ViaviStyle.layouts.menuLineHeight

                        onClicked: {
                            keyboard.currentKeyboardElf = dtsBattery_cfg_imgStartOffsetDisplay
                            keyboard.initialText = dtsBattery_cfg_imgStartOffsetDisplay.value
                            keyboardPopup.open()
                        }
                    }
                }

                Row{spacing:10
                    Text{
                        anchors.bottom: parent.bottom
                        verticalAlignment: Text.Bottom

                        font: ViaviStyle.layouts.largeBoldFont
                        text: "ImgWidth: "
                    }

                    FiberEditableText{
                        font: ViaviStyle.layouts.tableFont
                        width: 70
                        textHorizontalAlignment: Text.AlignHCenter
                        text: dtsBattery_cfg_imgPixelWidth.value

                        height: ViaviStyle.layouts.menuLineHeight

                        onClicked: {
                            keyboard.currentKeyboardElf = dtsBattery_cfg_imgPixelWidth
                            keyboard.initialText = dtsBattery_cfg_imgPixelWidth.value
                            keyboardPopup.open()
                        }
                    }

                    Text{
                        anchors.bottom: parent.bottom
                        verticalAlignment: Text.Bottom

                        font: ViaviStyle.layouts.largeBoldFont

                        text: "Row height: "
                    }

                    FiberEditableText{
                        font: ViaviStyle.layouts.tableFont
                        width: 70
                        textHorizontalAlignment: Text.AlignHCenter
                        text: dtsBattery_cfg_imgRowWidth.value

                        height: ViaviStyle.layouts.menuLineHeight

                        onClicked: {
                            keyboard.currentKeyboardElf = dtsBattery_cfg_imgRowWidth
                            keyboard.initialText = dtsBattery_cfg_imgRowWidth.value
                            keyboardPopup.open()
                        }
                    }
                }

                Row{spacing:10
                    Text{
                        anchors.bottom: parent.bottom
                        verticalAlignment: Text.Bottom

                        font: ViaviStyle.layouts.largeBoldFont
                        text: "ColorItensity: "
                    }

                    FiberEditableText{
                        font: ViaviStyle.layouts.tableFont
                        width: 70
                        textHorizontalAlignment: Text.AlignHCenter
                        text: dtsBattery_cfg_colorIntensity.value

                        height: ViaviStyle.layouts.menuLineHeight

                        onClicked: {
                            keyboard.currentKeyboardElf = dtsBattery_cfg_colorIntensity
                            keyboard.initialText = dtsBattery_cfg_colorIntensity.value
                            keyboardPopup.open()
                        }
                    }

                    Text{
                        anchors.bottom: parent.bottom
                        verticalAlignment: Text.Bottom

                        font: ViaviStyle.layouts.largeBoldFont
                        text: "MinTemp: "
                    }

                    FiberEditableText{
                        id: minTempEdit
                        font: ViaviStyle.layouts.tableFont
                        width: 70
                        textHorizontalAlignment: Text.AlignHCenter

                        height: ViaviStyle.layouts.menuLineHeight

                        onClicked: {
                            keyboard.currentKeyboardElf = dtsBattery_cfg_minTemp
                            keyboard.initialText = dtsBattery_cfg_minTemp.value
                            keyboardPopup.open()
                        }

                        Connections{
                            target: dtsBattery_cfg_minTemp
                            function onValueChanged() {
                                minTempEdit.text = dtsBattery_cfg_minTemp.value
                            }
                        }

                        Component.onCompleted: minTempEdit.text = dtsBattery_cfg_minTemp.value

                    }

                    Text{
                        anchors.bottom: parent.bottom
                        verticalAlignment: Text.Bottom

                        font: ViaviStyle.layouts.largeBoldFont
                        text: "MaxTemp: "
                    }

                    FiberEditableText{
                        id: maxTempEdit
                        font: ViaviStyle.layouts.tableFont
                        width: 70
                        textHorizontalAlignment: Text.AlignHCenter

                        height: ViaviStyle.layouts.menuLineHeight

                        onClicked: {
                            keyboard.currentKeyboardElf = dtsBattery_cfg_maxTemp
                            keyboard.initialText = dtsBattery_cfg_maxTemp.value
                            keyboardPopup.open()
                        }

                        Connections{
                            target: dtsBattery_cfg_maxTemp
                            function onValueChanged() {
                                maxTempEdit.text = dtsBattery_cfg_maxTemp.value
                            }
                        }

                        Component.onCompleted: maxTempEdit.text = dtsBattery_cfg_maxTemp.value
                    }

                }

                Row{spacing:10
                    Text{
                        anchors.bottom: parent.bottom
                        verticalAlignment: Text.Bottom

                        font: ViaviStyle.layouts.largeBoldFont
                        text: "Min Variation °/s: "
                    }

                    FiberEditableText{
                        id: minVariationEdit
                        font: ViaviStyle.layouts.tableFont
                        width: 70
                        textHorizontalAlignment: Text.AlignHCenter

                        height: ViaviStyle.layouts.menuLineHeight

                        onClicked: {
                            keyboard.currentKeyboardElf = dtsBattery_cfg_minVariation
                            keyboard.initialText = dtsBattery_cfg_minVariation.value
                            keyboardPopup.open()
                        }

                        Connections{
                            target: dtsBattery_cfg_minVariation
                            function onValueChanged() {
                                minVariationEdit.text = dtsBattery_cfg_minVariation.value
                            }
                        }

                        Component.onCompleted: minVariationEdit.text = dtsBattery_cfg_minVariation.value

                    }

                    Text{
                        anchors.bottom: parent.bottom
                        verticalAlignment: Text.Bottom

                        font: ViaviStyle.layouts.largeBoldFont
                        text: "Max Variation °/s: "
                    }

                    FiberEditableText{
                        id: maxVariationEdit
                        font: ViaviStyle.layouts.tableFont
                        width: 70
                        textHorizontalAlignment: Text.AlignHCenter

                        height: ViaviStyle.layouts.menuLineHeight

                        onClicked: {
                            keyboard.currentKeyboardElf = dtsBattery_cfg_maxVariation
                            keyboard.initialText = dtsBattery_cfg_maxVariation.value
                            keyboardPopup.open()
                        }

                        Connections{
                            target: dtsBattery_cfg_maxVariation
                            function onValueChanged() {
                                maxVariationEdit.text = dtsBattery_cfg_maxVariation.value
                            }
                        }

                        Component.onCompleted: maxVariationEdit.text = dtsBattery_cfg_maxVariation.value
                    }

                    Text{
                        anchors.bottom: parent.bottom
                        verticalAlignment: Text.Bottom

                        font: ViaviStyle.layouts.largeBoldFont
                        text: "Variation threashold: "
                    }

                    FiberEditableText{
                        id: variationThreasholdEdit
                        font: ViaviStyle.layouts.tableFont
                        width: 70
                        textHorizontalAlignment: Text.AlignHCenter

                        height: ViaviStyle.layouts.menuLineHeight

                        onClicked: {
                            keyboard.currentKeyboardElf = dtsBattery_cfg_variationThreashold
                            keyboard.initialText = dtsBattery_cfg_variationThreashold.value
                            keyboardPopup.open()
                        }

                        Connections{
                            target: dtsBattery_cfg_variationThreashold
                            function onValueChanged() {
                                variationThreasholdEdit.text = dtsBattery_cfg_variationThreashold.value
                            }
                        }

                        Component.onCompleted: variationThreasholdEdit.text = dtsBattery_cfg_variationThreashold.value
                    }
                    

                }

                Row{spacing:10
                    height: ViaviStyle.layouts.buttonHeight



                    Text{
                        anchors.bottom: parent.bottom
                        verticalAlignment: Text.Bottom

                        font: ViaviStyle.layouts.largeBoldFont
                        text: "Smoothed\ntype: "
                        color: ViaviStyle.colors.activeColor

                        MouseArea
                        {
                            anchors.fill: parent
                            onClicked: newSmoothingToggle.toggled = !newSmoothingToggle.toggled
                        }
                    }

                    ToggleButtonOption {
                        id: newSmoothingToggle
                        height: ViaviStyle.layouts.buttonHeight
                        leftText: "Off"
                        rightText: "On"

                        onToggledChanged: {
                            dtsBattery_cfg_newSmoothingEnabled.value = toggled
                        }

                        Connections{
                            target: dtsBattery_cfg_newSmoothingEnabled
                            function onValueChanged() {
                                newSmoothingToggle.toggled = dtsBattery_cfg_newSmoothingEnabled.value
                            }
                        }

                        Component.onCompleted: {
                            newSmoothingToggle.toggled = dtsBattery_cfg_newSmoothingEnabled.value
                        }
                    }

                    Text{
                        anchors.bottom: parent.bottom
                        verticalAlignment: Text.Bottom

                        font: ViaviStyle.layouts.largeBoldFont
                        text: "Variation threashold\nenabled: "
                        color: ViaviStyle.colors.activeColor

                        MouseArea
                        {
                            anchors.fill: parent
                            onClicked: variationThreasholdToggle.toggled = !variationThreasholdToggle.toggled
                        }
                    }

                    ToggleButtonOption {
                        id: variationThreasholdToggle
                        height: ViaviStyle.layouts.buttonHeight
                        leftText: "Off"
                        rightText: "On"

                        onToggledChanged: dtsBattery_cfg_variationThresholdEnabled.value = toggled

                        Connections{
                            target: dtsBattery_cfg_variationThresholdEnabled
                            function onValueChanged() {
                                variationThreasholdToggle.toggled = dtsBattery_cfg_variationThresholdEnabled.value
                            }
                        }

                        Component.onCompleted: variationThreasholdToggle.toggled = dtsBattery_cfg_variationThresholdEnabled.value
                    }

                    Text{
                        anchors.bottom: parent.bottom
                        verticalAlignment: Text.Bottom


                        font: ViaviStyle.layouts.largeBoldFont
                        text: "Ratio Stoke\nEnabled: "
                        color: ViaviStyle.colors.activeColor

                        MouseArea
                        {
                            anchors.fill: parent
                            onClicked: ratioStokeEnabled.toggled = !ratioStokeEnabled.toggled
                        }
                    }

                    ToggleButtonOption {
                        id: ratioStokeEnabled
                        height: ViaviStyle.layouts.buttonHeight
                        leftText: "Off"
                        rightText: "On"

                        onToggledChanged: {
                            dtsBattery_cfg_ratioStokeTime.value = toggled
                        }

                        Connections{
                            target: dtsBattery_cfg_ratioStokeTime
                            function onValueChanged() {
                                ratioStokeEnabled.toggled = dtsBattery_cfg_ratioStokeTime.value
                            }
                        }

                        Component.onCompleted: {
                            ratioStokeEnabled.toggled = dtsBattery_cfg_ratioStokeTime.value
                        }
                    }
                }

                ConfigLineComboBox{
                        text: "Config file: "
                        model: dtsBattery_res_configFiles.value
                        selectedIndexElf: dtsBattery_cfg_configFilesSelectedIndex
                }

                Row{
                    spacing: 10

                    Text{
                        anchors.bottom: parent.bottom
                        verticalAlignment: Text.Bottom

                        font: ViaviStyle.layouts.largeBoldFont
                        text: "Sweep\ninterval: "
                    }

                    FiberEditableText{
                        id: sweepIntervalEdit
                        font: ViaviStyle.layouts.tableFont
                        width: 70
                        textHorizontalAlignment: Text.AlignHCenter
                        text: dtsBattery_cfg_sweepInterval.value

                        height: ViaviStyle.layouts.menuLineHeight

                        onClicked: {
                            keyboard.currentKeyboardElf = dtsBattery_cfg_sweepInterval
                            keyboard.initialText = dtsBattery_cfg_sweepInterval.value
                            keyboardPopup.open()
                        }

                        Connections{
                            target: dtsBattery_cfg_sweepInterval
                            function onValueChanged() {
                                sweepIntervalEdit.text = dtsBattery_cfg_sweepInterval.value
                            }
                        }

                        Component.onCompleted: sweepIntervalEdit.text = dtsBattery_cfg_sweepInterval.value
                    }

                    Text{
                        anchors.bottom: parent.bottom
                        verticalAlignment: Text.Bottom

                        font: ViaviStyle.layouts.largeBoldFont
                        text: "Smothed\ntime: "
                    }

                    FiberEditableText{
                        id: smoothedTimeEdit
                        font: ViaviStyle.layouts.tableFont
                        width: 70
                        textHorizontalAlignment: Text.AlignHCenter
                        text: dtsBattery_cfg_smoothedTime.value

                        height: ViaviStyle.layouts.menuLineHeight

                        onClicked: {
                            keyboard.currentKeyboardElf = dtsBattery_cfg_smoothedTime
                            keyboard.initialText = dtsBattery_cfg_smoothedTime.value
                            keyboardPopup.open()
                        }

                        Connections{
                            target: dtsBattery_cfg_smoothedTime
                            function onValueChanged() {
                                smoothedTimeEdit.text = dtsBattery_cfg_smoothedTime.value
                            }
                        }

                        Component.onCompleted: smoothedTimeEdit.text = dtsBattery_cfg_smoothedTime.value
                    }

                    Text{
                        anchors.bottom: parent.bottom
                        verticalAlignment: Text.Bottom

                        font: ViaviStyle.layouts.largeBoldFont
                        text: "Acq\nTime: "
                    }

                    FiberEditableText{
                        id: acqTimeEdit
                        font: ViaviStyle.layouts.tableFont
                        width: 70
                        textHorizontalAlignment: Text.AlignHCenter
                        text: dtsBattery_cfg_acqTime.value

                        height: ViaviStyle.layouts.menuLineHeight

                        onClicked: {
                            keyboard.currentKeyboardElf = dtsBattery_cfg_acqTime
                            keyboard.initialText = dtsBattery_cfg_acqTime.value
                            keyboardPopup.open()
                        }

                        Connections{
                            target: dtsBattery_cfg_acqTime
                            function onValueChanged() {
                                acqTimeEdit.text = dtsBattery_cfg_acqTime.value
                            }
                        }

                        Component.onCompleted: acqTimeEdit.text = dtsBattery_cfg_acqTime.value
                    }

                }

                Row{spacing:10
                    height: ViaviStyle.layouts.buttonHeight
                    Text{
                        anchors.bottom: parent.bottom
                        verticalAlignment: Text.Bottom

                        font: ViaviStyle.layouts.largeBoldFont
                        text: "Config file: "
                    }

                    FiberEditableText{
                        id: file
                        font: ViaviStyle.layouts.tableFont
                        width: 250
                        textHorizontalAlignment: Text.AlignHCenter

                        height: ViaviStyle.layouts.menuLineHeight

                        function keyAccepted () {
                            text = keyboardAlphaPopup.textField
                            keyboardAlphaPopup.close()

                            keyboardAlphaPopup.accepted.disconnect(keyAccepted)
                            keyboardAlphaPopup.canceled.disconnect(keyCanceld)
                        }

                        function keyCanceld() {
                            keyboardAlphaPopup.close()

                            keyboardAlphaPopup.accepted.disconnect(keyAccepted)
                            keyboardAlphaPopup.canceled.disconnect(keyCanceld)
                        }

                        onClicked: {
                            keyboardAlphaPopup.accepted.connect(keyAccepted)
                            keyboardAlphaPopup.canceled.connect(keyCanceld)

                            keyboardAlphaPopup.initialText = text
                            keyboardAlphaPopup.open()
                        }

                        Connections{
                            target: dtsBattery_res_currentConfigName
                            function onValueChanged() {
                                file.text = dtsBattery_res_currentConfigName.value
                            }
                        }
                    }

                    FiberButton{
                       height: 50
                       width: 80
                        text: "Save"

                        onClicked:{
                            dtsBattery_act_saveConfig.invokeWithStringArg(file.text)
                        }
                    }
                    FiberButton{
                       height: 50
                       width: 80
                        text: "Load"

                        onClicked:{
                            dtsBattery_act_loadConfig.invokeWithStringArg(file.text)
                        }
                    }
                    FiberButton{
                       height: 50
                       width: 80
                        text: "Auto\nload"

                        onClicked:{
                            dtsBattery_act_makeLastConfigAutoLoad.invoke()
                        }
                    }
                    FiberButton{
                       height: 50
                       width: 80
                        text: "Disable\nauto load"

                        onClicked:{
                            dtsBattery_act_removeAutoLoad.invoke()
                        }
                    }
                }

                Row{spacing:10
                    FiberButton{
                       height: 50
                       width: 150
                        text: "updateImage"

                        onClicked:{
                            dtsBattery_act_updateImage.invoke()
                        }
                    }

                    Text{
                        text: "Circles: "
                        width: contentWidth
                    }
                    ToggleButtonOption {
                        id: circlesToggle
                        height: ViaviStyle.layouts.buttonHeight
                        leftText: "Off"
                        rightText: "On"
                        onToggledChanged: dtsBattery_cfg_batteryModeEnabled.value = toggled

                        Connections{
                            target: dtsBattery_cfg_batteryModeEnabled
                            function onValueChanged() {
                                circlesToggle.toggled = dtsBattery_cfg_batteryModeEnabled.value
                            }
                        }

                        Component.onCompleted: circlesToggle.toggled = dtsBattery_cfg_batteryModeEnabled.value
                    }

                    Text{
                        text: "HeatMap: "
                        width: contentWidth
                    }

                    ToggleButtonOption{
                        id: heatMapToggle
                        height: ViaviStyle.layouts.buttonHeight
                        leftText: "Off"
                        rightText: "On"
                        onToggledChanged: dtsBattery_cfg_heatMapEnabled.value = toggled

                        Connections{
                            target: dtsBattery_cfg_heatMapEnabled
                            function onValueChanged() {
                                heatMapToggle.toggled = dtsBattery_cfg_heatMapEnabled.value
                            }
                        }

                        Component.onCompleted: heatMapToggle.toggled = dtsBattery_cfg_heatMapEnabled.value
                    }

                    Text{
                        text: "Auto update: "
                        width: contentWidth
                    }

                    ToggleButtonOption{
                        id: autoUpdateToggle
                        height: ViaviStyle.layouts.buttonHeight
                        leftText: "Off"
                        rightText: "On"

                        onToggledChanged: dtsBattery_cfg_autoUpdateImage.value = toggled

                        Connections{
                            target: dtsBattery_cfg_autoUpdateImage
                            function onValueChanged() {
                                autoUpdateToggle.toggled = dtsBattery_cfg_autoUpdateImage.value
                            }
                        }

                        Component.onCompleted: autoUpdateToggle.toggled = dtsBattery_cfg_autoUpdateImage.value
                    }

                }

                Row{spacing:10
                    Text{
                        text: "Auto temp: "
                        width: contentWidth
                    }
                    ToggleButtonOption {
                        id: autoTempToggle
                        height: ViaviStyle.layouts.buttonHeight
                        leftText: "Off"
                        rightText: "On"
                        onToggledChanged: dtsBattery_cfg_autoTempFlag.value = toggled

                        Connections{
                            target: dtsBattery_cfg_autoTempFlag
                            function onValueChanged() {
                                autoTempToggle.toggled = dtsBattery_cfg_autoTempFlag.value
                            }
                        }

                        Component.onCompleted: autoTempToggle.toggled = dtsBattery_cfg_autoTempFlag.value
                    }

                    Text{
                        text: "Fer temp: "
                        width: contentWidth
                    }
                    ToggleButtonOption {
                        id: ferToggle
                        height: ViaviStyle.layouts.buttonHeight
                        leftText: "Off"
                        rightText: "On"

                        onToggledChanged: dtsBattery_cfg_fahrenheitTempFlag.value = toggled

                        Connections{
                            target: dtsBattery_cfg_fahrenheitTempFlag
                            function onValueChanged() {
                                ferToggle.toggled = dtsBattery_cfg_fahrenheitTempFlag.value
                            }
                        }

                        Component.onCompleted: ferToggle.toggled = dtsBattery_cfg_fahrenheitTempFlag.value
                    }

                    Text{
                        text: "Interpolate: "
                        width: contentWidth
                    }
                    ToggleButtonOption {
                        id: interpolateToggle
                        height: ViaviStyle.layouts.buttonHeight
                        leftText: "Off"
                        rightText: "On"
                        onToggledChanged: dtsBattery_cfg_interpolateFlag.value = toggled

                        Connections{
                            target: dtsBattery_cfg_interpolateFlag
                            function onValueChanged() {
                                interpolateToggle.toggled = dtsBattery_cfg_interpolateFlag.value
                            }
                        }

                        Component.onCompleted: interpolateToggle.toggled = dtsBattery_cfg_interpolateFlag.value

                    }

                    Text{
                        text: "Auto save: "
                        width: contentWidth
                    }
                    ToggleButtonOption {
                        id: autoSaveToggle
                        height: ViaviStyle.layouts.buttonHeight
                        leftText: "Off"
                        rightText: "On"
                        onToggledChanged: dtsBattery_cfg_autoSaveFlag.value = toggled

                        Connections{
                            target: dtsBattery_cfg_autoSaveFlag
                            function onValueChanged () {
                                autoSaveToggle.toggled = dtsBattery_cfg_autoSaveFlag.value
                            }
                        }

                        Component.onCompleted: autoSaveToggle.toggled = dtsBattery_cfg_autoSaveFlag.value

                    }
                }

                Row{spacing:10
                    FiberButton{
                       height: 50
                       width: 150
                        text: "fillFromTrace"

                        onClicked:{
                            dtsBattery_act_centerTraceFill.invoke()
                        }
                    }

                    FiberComboBox{
                        id: comboBox

                        Connections{
                            target: dtsBattery_cfg_autoFillType
                            function onValueChanged() {
                                comboBox.currentIndex = dtsBattery_cfg_autoFillType.enumIndex(dtsBattery_cfg_autoFillType.value)
                            }
                        }

                        onCurrentIndexChanged: {
                            dtsBattery_cfg_autoFillType.value = dtsBattery_cfg_autoFillType.enumValue(currentIndex)
                        }

                        ListModel {
                            id: comboModel

                            Component.onCompleted: {
                                comboModel.clear()
                                for(var index = 0; index < dtsBattery_cfg_autoFillType.enumCount; ++index){
                                   comboModel.append({"text": dtsBattery_cfg_autoFillType.enumLabel(index)})
                                }
                            }
                        }

                        model: comboModel

                        Component.onCompleted: {
                            comboBox.currentIndex = dtsBattery_cfg_autoFillType.enumIndex(dtsBattery_cfg_autoFillType.value)
                        }
                    }

                    FiberButton{
                       height: 50
                       width: 150
                        text: "fillAll"

                        onClicked:{
                            dtsBattery_act_updateElements.invoke()
                        }
                    }
                }

                Row{spacing:10
                    height: flickableId.height
                    Flickable{
                        id: flickableId
                        width: column.width
                        height: ViaviStyle.layouts.buttonHeight * 5
                        clip: true
                        contentHeight: grid.height
                        contentWidth: grid.width

                        boundsBehavior: Flickable.StopAtBounds

                        Grid {
                            id: grid
                            columns: dtsBattery_cfg_nbOfColumns.value
                            rows: dtsBattery_cfg_nbOfRows.value

                            width: columns * cellSize

                            property int cellSize: 85

                            Repeater{
                                model: dtsBattery_res_elements.value


                                delegate: Item {
                                    width: grid.cellSize
                                    height: ViaviStyle.layouts.buttonHeight

                                    function checkIfRefElement(index){
                                        var column = index % dtsBattery_cfg_nbOfColumns.value
                                        switch(dtsBattery_cfg_autoFillType.value){
                                        case dtsBattery_cfg_autoFillType.enums.edaftRowFirst:
                                            if(column === 0){
                                                return true
                                            }
                                            break
                                        case dtsBattery_cfg_autoFillType.enums.edaftRowMargins:
                                            if((column === 0) || (column === (dtsBattery_cfg_nbOfColumns.value - 1))){
                                                return true
                                            }
                                            break
                                        case dtsBattery_cfg_autoFillType.enums.edaftFirstLast:
                                            if(index === 0 || index === dtsBattery_cfg_nbOfColumns.value * dtsBattery_cfg_nbOfRows.value - 1){
                                                return true
                                            }
                                            break;
                                        }
                                        return false
                                    }

                                    Rectangle{
                                        anchors.fill: parent
                                        border.color: "black"

                                        color: model.index === dtsBattery_cfg_setupSelectedIndex.value ? "yellow" : "transparent"
                                    }

                                    Rectangle{
                                        width: parent.width
                                        height: 10

                                        anchors.bottom: parent.bottom

                                        visible: checkIfRefElement(model.index)
                                        color: "green"
                                    }

                                    RowLayout{
                                        anchors.fill: parent

                                        spacing: ViaviStyle.layouts.mediumMargin

                                        Text{

                                            Layout.alignment: Qt.AlignVCenter

                                            font: ViaviStyle.layouts.smallBoldFont
                                            text: model.index
                                        }

                                        VerticalSeparator{
                                            y: ViaviStyle.layouts.smallMargin
                                            height: parent.height - 2 * ViaviStyle.layouts.smallMargin
                                            anchors.top : undefined
                                            anchors.bottom : undefined
                                        }

                                        Text{
                                            Layout.alignment: Qt.AlignVCenter
                                            Layout.fillWidth: true

                                            elide: Text.ElideRight

                                            font: ViaviStyle.layouts.smallBoldFont
                                            text: model.center
                                        }
                                    }

                                    PopupMouseArea{
                                        anchors.fill: parent
                                        longPressMenu: tablePopup
                                        onClicked: {
                                            var notChanged = dtsBattery_cfg_setupSelectedIndex.value === model.index
                                            dtsBattery_cfg_setupSelectedIndex.value = model.index

                                            if(notChanged){
                                                keyboard.currentKeyboardElf = dtsBattery_cfg_setupNewCenter
                                                keyboard.initialText = model.center
                                                keyboardPopup.open()
                                            }
                                        }
                                        onBeforePressAndHold: {
                                            dtsBattery_cfg_setupSelectedIndex.value = model.index
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}
