import QtQuick 2.1
import graph_plugin 1.0
import elf_plugin 1.0

import "ViaviStyle"

CursorDragFiber {
    id: cursorYDragFiber
    isVerticalCursor: false

    anchors.right: parent.right
    anchors.left: parent.left

    height: 33
    transform: Translate { y: -(dragAreaAlias.height-1)/2 }

    highlightAlias.width: width
    highlightAlias.height: height - 20
    highlightAlias.rotation: 0

    dragAreaAlias.drag.axis: Drag.YAxis
    dragAreaAlias.drag.minimumX: 0
    dragAreaAlias.drag.maximumY: parent.height-1

    nameAlias.y: y - nameAlias.contentHeight < 0 ? height - nameAlias.contentHeight : 0

    function updateConnectedCursorOffset(){

        //don't take into account AB cursor as it will be handled in the backend in module_trace
        //this will ensure position updates of connected cursor on the same thread
        //and will get rid of A-B distance flickering number problem
        if (trace_cfg_cursorSelected.enums.ecCursor_AB === trace_cfg_cursorSelected.value)
            return;

        if(connectedCursor){
            connectedCursorOffset = cursorDragAlias.y - connectedCursor.y
        }

    }

    function updatePosition(newPos, fromUser, propagate){

        if (!trace_res_cursorsLocked.value)
        {
            y = newPos
            if(fromUser){
                updateElf.invokeWithStringArg(GraphCursor.cursor.posValue)

                //don't take into account AB cursor as it will be handled in the backend in module_trace
                //this will ensure position updates of connected cursor on the same thread
                //and will get rid of A-B distance flickering number problem
                if (trace_cfg_cursorSelected.enums.ecCursor_AB === trace_cfg_cursorSelected.value)
                    return;

                if(propagate && connectedCursor){
                    connectedCursor.updatePosition(y - connectedCursorOffset, fromUser, false)
                }
            }
        }
    }
    
    function setPosValue(posValue){
       if (GraphCursor.cursor !== null){
	       GraphCursor.cursor.posValue = posValue
           y = GraphCursor.cursor.posOnScreen
       }
	}

    onYChanged: {

        if (GraphCursor.cursor !== null){

            if (y < 0)
                y = 0;

            GraphCursor.cursor.setPosOnScreen(y)

            // anchor drag to graph cursor
            y = GraphCursor.cursor.posOnScreen

            if(pressed){
                updatePosition(y, true, true)
            }

        }
    }

    GraphCursor.onXPosOnScreenChanged: {
        cursorDragAlias.y = GraphCursor.cursor.posOnScreen
    }

    onPressedChanged: {

        if(parentTrace){
           parentTrace.lastUsedCursor = cursorYDragFiber
        }
        updateConnectedCursorOffset()

    }

}
