import QtQuick 2.3
import QtQuick.Controls 2.0
import elf_plugin 1.0

import "ViaviStyle"

Text {
    id: cursorAInfoText

    property CursorDragFiber cursorX
    property CursorDragFiber cursorY

    property ElfData unitDisplayedX
    property ElfData unitDisplayedY

    verticalAlignment: Text.AlignVCenter

    minimumPixelSize : ViaviStyle.layouts.smallFontSize / 2

    fontSizeMode: Text.Fit
    font: ViaviStyle.layouts.cursorInfoFont

    text: cursorX ?
                   (cursorX.text + ": " + Math.round(cursorX.displayedXValue * 100) / 100 + " " +   //X value
                    unitDisplayedX.value + " " + //X unit

                       + getYValue() + " " + //Y value
                    (unitDisplayedY.value)) //Y unit
                 : ""

    color: ViaviStyle.colors.activeColor

    function getYValue(){
       var result;

       //Note:
       //cursorX has X and Y, Y = f(x)
       //cursorY has X and Y, we do not need Y value so we displayedXValue
       //to retreive cursorY position on Y axis.

       switch (trace_cfg_cursorDraw.value) {
       case trace_cfg_cursorDraw.enums.ecDraw_Cursor_X:
           result = (cursorX) ? Math.round(cursorX.displayedYValue * 1000) / 1000 : 0;
           break;
       case trace_cfg_cursorDraw.enums.ecDraw_Cursor_Y:
           result = (cursorY) ? Math.round(cursorY.displayedXValue * 1000) / 1000 : 0
           break;
       case trace_cfg_cursorDraw.enums.ecDraw_Cursor_XY:
           result = (cursorY) ? Math.round(cursorY.displayedXValue * 1000) / 1000 : 0;
           break;
       default:
           break;
       }

       return result;
   }

}
