import QtQuick 2.1
import graph_plugin 1.0
import elf_plugin 1.0

import "ViaviStyle"

Item {
    id: cursorDrag

    property color color: ViaviStyle.colors.redCursorColor
    property alias text: cursorName.text

    property alias nameAlias: cursorName
    property alias dragAreaAlias: dragArea
    property alias highlightAlias: cursorHighlight
    property alias cursorDragAlias: cursorDrag

    property Item connectedCursor
    property ElfData updateElf
    property ElfData backendItem
    property Item parentTrace
    property Item parentGraph
    property ValueAxis xAxis
    property bool isVerticalCursor: true
    property real refrenceValue: backendItem.value
    
    property bool additionalCursor: false
    
    property real posValue: GraphCursor.cursor !== null ? GraphCursor.cursor.posValue : 0
    
    Connections{
        target: backendItem
        function onValueChanged() {
            if(!cursorDrag.pressed){
            	if(xAxis && xAxis.rangeOrder === ValueAxis.Decreasing){
            	    cursorDrag.setPosValue(xAxis.maxValue + xAxis.minValue - backendItem.value)   
            	}
            	else{
                    cursorDrag.setPosValue(backendItem.value)
                }
            }
         }
    }
    
    onVisibleChanged: {
        if(visible){
            cursorDrag.setPosValue(cursorDrag.refrenceValue)
            if(cursorDrag.additionalCursor){
                if(xAxis && xAxis.rangeOrder === ValueAxis.Decreasing){
            	    updateElf.invokeWithStringArg(xAxis.maxValue + xAxis.minValue - GraphCursor.cursor.posValue)   
            	}
            	else{
                    updateElf.invokeWithStringArg(GraphCursor.cursor.posValue)
                }                
            }
        }
    }

    property double displayedXValue: {
           return (xAxis && xAxis.rangeOrder === ValueAxis.Decreasing)
                                        ? xAxis.maxValue + xAxis.minValue - parent.posValue
                                        : parent.posValue
    }
    property double displayedYValue: parent.yValues[parent.primaryPlotIndex] !== undefined  ? parent.yValues[parent.primaryPlotIndex] : 0

    property int backendId:-1

    property real connectedCursorOffset

    visible: parent.opacity !== 0.0
    clip: true

    signal clicked(var mouse)
    signal released(var mouse)
    property alias pressed: dragArea.pressed
    property bool selected: parentTrace.lastUsedCursor === cursorDrag
                            || parentTrace.lastUsedCursor === connectedCursor

    function colorWithAlpha(color, alpha) {
        return Qt.rgba(color.r, color.g, color.b, alpha)
    }

    signal sgnGetCursorStatus(Item cursorDrag)

    Text {
        id: cursorName
        color: cursorDrag.color
        font: selected ? ViaviStyle.layouts.mediumBoldFont: ViaviStyle.layouts.smallFont
        visible: parent.enabled

    }

    Rectangle {
        id: cursorHighlight
        anchors.centerIn: parent
        rotation: 90
        opacity: 0
        gradient: Gradient {
            GradientStop { position: 0.0; color: colorWithAlpha(cursorDrag.color, 0.0) }
            GradientStop { position: 0.45; color: colorWithAlpha(cursorDrag.color, 0.5)}
            GradientStop { position: 0.5; color: colorWithAlpha(cursorDrag.color, 1.0) }
            GradientStop { position: 0.55; color: colorWithAlpha(cursorDrag.color, 0.5) }
            GradientStop { position: 1.0; color: colorWithAlpha(cursorDrag.color, 0.0) }
        }
        Behavior on opacity {
            NumberAnimation { duration: 250 }
        }
    }

    MouseArea {
        id: dragArea
        enabled: !trace_res_cursorsLocked.value
        anchors.fill: parent
        drag.target: parent
        onPressed: {
            sgnGetCursorStatus(cursorDrag);
            cursorHighlight.opacity = 1;
        }
        onReleased: cursorHighlight.opacity = 0;
    }


    Component.onCompleted:
    {
        dragArea.clicked.connect(clicked)
        dragArea.released.connect(released)
        if(parentTrace){
            sgnGetCursorStatus.connect(parentGraph.onCursorFocusChanged)
        }
    }
}
