import QtQuick 2.5
import QtQuick.Layouts 1.2
import "ViaviStyle"

import elf_plugin 1.0

ConfigLineBase{
    id: root

    property alias model: repeater.model

    property ElfData buttonAction
    property ElfData selectedIndexElf

    Item{
        id: optionsContainer
        anchors.fill: parent

        Row{
            id: row
            anchors.top: parent.top
            anchors.bottom: parent.bottom
            spacing: ViaviStyle.layouts.mediumMargin
            Repeater{
                id: repeater
                Item{
                    id: delegate

                    property bool selected: root.selectedIndexElf
                                        ? root.selectedIndexElf.value === model.index
                                        : model.selected

                    anchors.top: parent.top
                    anchors.bottom: parent.bottom
                    width: (optionsContainer.width  - (repeater.count - 1) * row.spacing) / repeater.count

                    Rectangle{
                        anchors.fill: parent

                        color: mouseArea.pressed ? ViaviStyle.colors.checkedItemColor : ViaviStyle.colors.activeColor

                        visible: delegate.selected || mouseArea.pressed
                    }

                    Text{
                        anchors.centerIn: parent

                        font: delegate.selected ? ViaviStyle.layouts.veryLargeBoldFont : ViaviStyle.layouts.largeFont
                        color: delegate.selected ? ViaviStyle.colors.activeItemTextColor : ViaviStyle.colors.mainInfoColor

                        text: model.text
                    }

                    MouseArea{
                        id: mouseArea
                        anchors.fill: parent

                        onClicked: {
                            if(root.selectedIndexElf){
                                root.selectedIndexElf.value = model.index
                            }else if(root.buttonAction){
                                root.buttonAction.invokeWithStringArg(model.index)
                            }
                        }
                    }
                }
            }
        }
    }
}
