import QtQuick 2.5
import QtQuick.Layouts 1.2
import "ViaviStyle"

ConfigLineBase{
    id: root

    property alias infoText: infoTextId.text

    Rectangle{
        anchors.fill: parent
        color: ViaviStyle.colors.disabledItemColor

        border.color: ViaviStyle.colors.activeColor
        border.width: ViaviStyle.layouts.borderSize * 3

        Flickable{
            anchors.fill: parent
            anchors.leftMargin: ViaviStyle.layouts.largeMargin
            anchors.rightMargin: ViaviStyle.layouts.largeMargin

            contentWidth: infoTextId.width

            boundsBehavior: Flickable.StopAtBounds
            clip: true

            Text{
                id: infoTextId

                anchors.top: parent.top
                anchors.bottom: parent.bottom

                width: contentWidth

                verticalAlignment: Text.AlignVCenter
                horizontalAlignment: Text.AlignLeft

                color: ViaviStyle.colors.mainInfoColor
                font: ViaviStyle.layouts.tableFont
            }
        }
    }
}
