import QtQuick 2.5
import QtQuick.Layouts 1.2
import QtQuick.Controls 2.0
import elf_plugin 1.0

import "ViaviStyle"

ConfigLineBase{
    id: root

    property alias model: comboBox.model

    property ElfData selectedIndexElf

    WizardComboBox{
        id: comboBox

        anchors.fill: parent

        padding: ViaviStyle.layouts.largeMargin

        textRole: 'text'

        Connections{
            target: comboBox.model

            onModelReset: comboBox.currentIndex = root.selectedIndexElf.value
        }

        Connections{
            target: root.selectedIndexElf

            onValueChanged: comboBox.currentIndex = root.selectedIndexElf.value
        }

        onCurrentIndexChanged: root.selectedIndexElf.value = comboBox.currentIndex

        Component.onCompleted: comboBox.currentIndex = root.selectedIndexElf.value
    }
}
