import QtQuick 2.3
import "./UtilUiQt/Viavi_Colors.js" as VColor

Item {
    CableToggleFiberPopup { id: enablePopupId }

    width: grid.cellWidth + 2
    height: grid.cellHeight + 2
    clip: true 
    
    // Use Q_ENUM when enum not negative or supported in QML
    function cable_alarm_color ( cable_co_list, i ) 
	{
		var cable_back_col = VColor.cViaviColorLightGray2;	
	
		if (cable_co_list.Cable_List[i] != undefined) 
		{
		  if (!cable_co_list.Cable_List[i].Fiber_To_Test) 
		  {
		      cable_back_col = VColor.cViaviColorGray;
		  } 
		  else if (cable_co_list.Cable_List[i].Fiber_Test_Done) 
		  {
		    var alarm = cable_co_list.Cable_List[i].Alarm_Status;
		    
	    	if (alarm == 1) {
				cable_back_col = VColor.cViaviColorGreen;
			}
			else if (alarm == -1) {
				cable_back_col = VColor.cViaviColorRed;
			}
			else if (alarm == -2) {
				cable_back_col = VColor.cViaviColorYellow;
			}
			else
			{
				cable_back_col = VColor.cViaviColorLightGray2;
			}
		  }
		}
		
		return cable_back_col;
	}

    Column {
    	Rectangle { 

    		width: grid.cellWidth
    		height: grid.cellHeight
            border.width: 1
            border.color: VColor.cViaviColorGray
            opacity: 1
    		
    		color: cable_alarm_color( cable_co_list, index )
    		
    		Text {
            	text: Fiber_Number
				color: VColor.cViaviColorLogoPurple
                font.pixelSize: 24
                font.family: "Bitstream Vera Sans Roman"
                anchors.horizontalCenter: parent.horizontalCenter
                anchors.verticalCenter: parent.verticalCenter
			}
			
			Rectangle {
				visible: Fiber_Channel != 0
				
				color: VColor.cViaviColorLightBlue
				
				height: parent.height / 4
				width: height
				
				radius: width / 2
				
				x: 4
				y: 4
				
				Text {
	            	text: Fiber_Channel
					color: VColor.cViaviColorLogoPurple
	                font.pixelSize: 12
	                font.family: "Bitstream Vera Sans Roman"
	                anchors.horizontalCenter: parent.horizontalCenter
	                anchors.verticalCenter: parent.verticalCenter
				}
			}
			
			Rectangle {
				color: (index == cable_co_list.Index) ? VColor.cViaviColorLogoPurple : "transparent"
				width: parent.width
				height: parent.height / 4
				y:  (parent.height / 4) * 3
			}
    	}
    }

    PopupMouseArea {
        anchors.fill: parent
        longPressMenu: enablePopupId
        z: parent.z + 1
        onBeforePressAndHold: {
            cable_co_list.Index = index
        }

        onClicked: {
            cable_co_list.Index = index
        }
    }        
}

