import QtQuick 2.5
import QtQuick.Controls 2.0
import QtQuick.Layouts 1.2

import "./UtilUiQt/Viavi_Colors.js" as VColor
import "ViaviStyle"

import elf_plugin 1.0
import libfo 1.0

Rectangle {
    id: screen
    width: parent.width
    height: parent.height
    color: VColor.cViaviColorGray
    
    property int lineHeight: 40
    
    property string filterLabel: ""

    focus: true
    
    enabled: !cable_co_list.Event_Lock
    opacity: cable_co_list.Event_Lock ? 0.8 : 1
    
    function openFilterKeyBoard() {
    	keyboardAlphaPopup.initialText = filterLabel
        keyboardAlphaPopup.open()
    }
    
    function applyFilter(txtOutput, validation) {   
        if (validation === true)
        	{
        	filterLabel = txtOutput
        	}
    }

    Rectangle {
        id: head
        color: VColor.cViaviColorGray
        height: lineHeight
        width: parent.width
        
        Rectangle {
	    	id: labelFilter
	    	
		    anchors.right: head.right
	        anchors.verticalCenter: parent.verticalCenter
	        
	        height: head.height - 4
	        width: height
	        
	        color: VColor.cViaviColorLightGray2
	        
		    Image { // Find icons
		        fillMode: Image.PreserveAspectFit
		        source:"/acterna/storage/look-and-feel/generic/Icon_Search_32.png"
		        
		        anchors.fill: parent
		        anchors.margins: 2
		        
		        MouseArea {
		        	anchors.fill: parent
		        	onClicked: { openFilterKeyBoard() }
		        }
		    }
	    }

        Rectangle {
            id: recAllFiber
            width: parent.width / 2 - labelFilter.width
            height: head.height - 4
            color: VColor.cViaviColorLightGray2
            // anchors.right: head.right
            anchors.right: labelFilter.left
            anchors.verticalCenter: parent.verticalCenter

            Rectangle {
                id: recPassFiber
                color: VColor.cViaviColorGreen
                height:parent.height
                width: cable_co_list.Nb_Label_To_Test > 0 ? recAllFiber.width * cable_co_list.Nb_Label_Pass / cable_co_list.Nb_Label_To_Test : 0
                anchors.left: parent.left
            }

            Rectangle {
                id: recFailFiber
                color: VColor.cViaviColorRed
                height:parent.height
                width: cable_co_list.Nb_Label_To_Test > 0 ? recAllFiber.width * cable_co_list.Nb_Label_Fail / cable_co_list.Nb_Label_To_Test : 0
                anchors.left: recPassFiber.right
            }

            Text {
                id: textNumberFiberTested
                anchors.horizontalCenter: parent.horizontalCenter
                anchors.verticalCenter: parent.verticalCenter
                horizontalAlignment: Text.AlignHCenter
                verticalAlignment: Text.AlignVCenter
                text: cable_co_list.Txt_Tested + " " + (cable_co_list.Nb_Label_Pass+cable_co_list.Nb_Label_Fail) + "/" + cable_co_list.Nb_Label_To_Test
                color: "white"
                font.pixelSize: 24
                font.family: "DejaVu LGC SansCondensed"
            }
        }

        Image { // The icon metaphor
            id: passedMetaphor
            anchors.left: parent.left
            anchors.leftMargin: 10
            anchors.verticalCenter: parent.verticalCenter
            height: 32
            fillMode: Image.PreserveAspectFit
            source:"/acterna/storage/look-and-feel/generic/Check_32_Enterprise.png"
            
            visible: false
        }

        Text {
            id: textPassFiber
            anchors.left: passedMetaphor.right
            anchors.leftMargin: 10 //40
            anchors.verticalCenter: parent.verticalCenter
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            // Dont use italics
            text: cable_co_list.Nb_Label_Pass + " " + cable_co_list.Txt_Pass
            color: VColor.cViaviColorGreen
            font.pixelSize: 24
            font.family: "DejaVu LGC SansCondensed"
        }

        Image { // The icon metaphor
            id: failedMetaphor
            anchors.left: textPassFiber.right
            anchors.leftMargin: 20
            anchors.verticalCenter: parent.verticalCenter
            height: 32
            fillMode: Image.PreserveAspectFit
            source:"/acterna/storage/look-and-feel/generic/Cross_32_Enterprise.png"
            
            visible: false
        }

        Text {
            id: textFailFiber
            anchors.left: failedMetaphor.right
            anchors.leftMargin: 10
            anchors.verticalCenter: parent.verticalCenter
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            text: cable_co_list.Nb_Label_Fail + " " + cable_co_list.Txt_Fail
            color: VColor.cViaviColorRed
            font.pixelSize: 24
            font.family: "DejaVu LGC SansCondensed"
        }
    }
    
    Rectangle {
		id: currentFilter
		
		width: head.width
		height: lineHeight * 2 / 3
		
		color: VColor.cViaviColorLightGray3
		
		visible: filterLabel.length > 0
		
		anchors.top: head.bottom
		anchors.horizontalCenter: head.horizontalCenter
		
		Text {
            anchors.fill: parent
            
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            text: filterLabel
            color: "white"
            font.pixelSize: 20
            font.family: "DejaVu LGC SansCondensed"
        }
	}

    Item {
        id: body
        anchors.fill: parent
        anchors.topMargin: head.height + ( currentFilter.visible ? currentFilter.height : 0 )
        anchors.bottomMargin: cable_result_information.visible ? cable_result_information.height : 0
        clip: true

        ListView {
            id: label_list

            anchors.fill: parent
            boundsBehavior: Flickable.StopAtBounds
            currentIndex: cable_co_list.Label_Index

            highlightMoveVelocity: -1
            highlightMoveDuration: -1

            model: cable_co_list.Cable_Label_List
            delegate: Cable_Co_Enterprise_Slm_Line {}
            
            Component.onCompleted: {
            	label_list.positionViewAtIndex(cable_co_list.Label_Index, ListView.Center)
            }
        }

        Cable_Co_Enterprise_MPO {
            visible: (cable_co_list.Label_Index_Open != -1)

            parent: label_list.currentItem

            anchors.top: parent != undefined ? parent.top : undefined
            anchors.topMargin: 50
            anchors.left: parent.left
            anchors.right: parent.right
            anchors.margins: ViaviStyle.layouts.veryLargeMargin

            groupe_size: cable_co_list.MPO_Size
            fiber_start_index: cable_co_list.Cable_Co_Get_First_Index_Of_Label(label_list.currentIndex)
        }
    }

    Cable_Co_Result_Informations {
        id: cable_result_information

        height: 3*48
        width: parent.width
        visible: cable_co_list.Result_Window_Displayed

        anchors.bottom: parent.bottom
     }
     
     	KeyboardUtils { id: keyboardUtils }
	
    Popup{
        id: keyboardAlphaPopup

        width: fiberMainPage.width
        height: fiberMainPage.height

        property alias textField: keyboardAlpha.textField
        property alias initialText: keyboardAlpha.initialText

        parent: screen
        
        anchors.centerIn: screen

        modal: true

        closePolicy: Popup.NoAutoClose

        background: Rectangle{
        	anchors.fill: parent
        	color: ViaviStyle.colors.transparentBackgroundColor
        }

        signal accepted()
        signal canceled()

        contentItem: Item {

            anchors.fill: parent

            KeyboardAlpha{
                id: keyboardAlpha

                inputTextMaxLength: 60
                titleText: cable_co_list.Txt_Go_To_Fiber
                
			    onAccepted: {
			        applyFilter(textField, true);
			        
			        keyboardAlphaPopup.close()
			        keyboardAlphaPopup.accepted()
			    }
			
			    onCanceled: {
			        applyFilter(textField, false);
			        
			        keyboardAlphaPopup.close()
			        keyboardAlphaPopup.canceled()
			    }
            }
        }
    }

    Keys.onPressed: {
        if (event.key == Qt.Key_Left) {
            if ( cable_co_list.MPO_Size > 1 )
            {
                if ( (cable_co_list.Index % cable_co_list.MPO_Size) > 0) {
                    cable_co_list.Index = cable_co_list.Index - 1;
                    cable_co_list.Label_Selection_Mode = false;
                }
            }
        } else if (event.key == Qt.Key_Right) {
            if ( cable_co_list.MPO_Size > 1 )
            {
                if ( cable_co_list.Label_Selection_Mode )
                    {
                    cable_co_list.Label_Selection_Mode = false;
                    cable_co_list.Index = cable_co_list.Cable_Co_Get_First_Index_Of_Label(cable_co_list.Label_Index);
                    cable_co_list.Label_Index_Open = cable_co_list.Label_Index;
                    }
                else if ( (cable_co_list.Index % cable_co_list.MPO_Size) < (cable_co_list.MPO_Size - 1))
                    {
                    cable_co_list.Index = cable_co_list.Index + 1;
                    cable_co_list.Label_Index_Open = cable_co_list.Label_Index;
                    }
                }
        } else if (event.key == Qt.Key_Up && event.isAutoRepeat == false) {
            if (cable_co_list.Label_Index > 0) {
                cable_co_list.Label_Selection_Mode = true;
                cable_co_list.Label_Index = cable_co_list.Label_Index - 1;
                cable_co_list.Index = cable_co_list.Cable_Co_Get_First_Index_Of_Label(cable_co_list.Label_Index);
            }
        } else if (event.key == Qt.Key_Down && event.isAutoRepeat == false) {
            if ( (cable_co_list.Label_Index + 1) < cable_co_list.Nb_Label ) {
                cable_co_list.Label_Selection_Mode = true;
                cable_co_list.Label_Index = cable_co_list.Label_Index + 1;
                cable_co_list.Index = cable_co_list.Cable_Co_Get_First_Index_Of_Label(cable_co_list.Label_Index);
            }
        } else if (event.key == Qt.Key_Up && event.isAutoRepeat != false) {
            if ( (cable_co_list.Label_Index - 10) > 0) {
                cable_co_list.Label_Selection_Mode = true;
                cable_co_list.Label_Index = cable_co_list.Label_Index - 10;
                cable_co_list.Index = cable_co_list.Cable_Co_Get_First_Index_Of_Label(cable_co_list.Label_Index);
            } else {
                cable_co_list.Label_Selection_Mode = true;
                cable_co_list.Label_Index = 0;
                cable_co_list.Index = cable_co_list.Cable_Co_Get_First_Index_Of_Label(cable_co_list.Label_Index);
            }
        } else if (event.key == Qt.Key_Down && event.isAutoRepeat != false) {
            if ( (cable_co_list.Label_Index + 10) < cable_co_list.Nb_Label ) {
                cable_co_list.Label_Selection_Mode = true;
                cable_co_list.Label_Index = cable_co_list.Label_Index + 10;
                cable_co_list.Index = cable_co_list.Cable_Co_Get_First_Index_Of_Label(cable_co_list.Label_Index);
            } else {
                cable_co_list.Label_Selection_Mode = true;
                cable_co_list.Label_Index = cable_co_list.Nb_Label-1;
                cable_co_list.Index = cable_co_list.Cable_Co_Get_First_Index_Of_Label(cable_co_list.Label_Index);
            }
        } else if (event.key == Qt.Key_Return) {
            cable_co_list.Label_Index_Open = ( cable_co_list.Label_Index != cable_co_list.Label_Index_Open ? cable_co_list.Label_Index : -1 );
            cable_co_list.Label_Selection_Mode = true;
            cable_co_list.Index = cable_co_list.Cable_Co_Get_First_Index_Of_Label(cable_co_list.Label_Index);
        }
    }
}
