import QtQuick 2.5
import QtQuick.Layouts 1.2
import "ViaviStyle"

FiberContainer {
    id: analysisRoot
    property int methodType: 0

    height: ViaviStyle.layouts.buttonHeight //tab selection
            + ViaviStyle.layouts.mediumMargin
            + ViaviStyle.layouts.buttonHeight //calculate button
            + ViaviStyle.layouts.mediumMargin

    Rectangle {
        id: buttonRow

        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        height: ViaviStyle.layouts.buttonHeight

        color: ViaviStyle.colors.borderColor

        Row {
            id:upperRow
            anchors.left: parent.left
            anchors.leftMargin: ViaviStyle.layouts.largeMargin
            anchors.top: parent.top
            anchors.bottom: parent.bottom
            width: parent.width / 2
            spacing: ViaviStyle.layouts.mediumMargin

            function resetResultText()
            {
                analysis_act_reset.invoke()
            }

            CheckTextButton {

                height: parent.height
                width: parent.width / 4
                checked: analysis_cfg_measType.value === analysis_cfg_measType.enums.emtLoss

                text: analysis_res_lossBtnLabel.value
                centerContent: true

                mouseArea.onClicked: {
                    analysis_cfg_measType.value = analysis_cfg_measType.enums.emtLoss
                    upperRow.resetResultText()
                }
            }

            CheckTextButton {
                height: parent.height
                width: parent.width / 4
                checked: analysis_cfg_measType.value === analysis_cfg_measType.enums.emtOrl

                text: analysis_res_orlBtnLabel.value
                centerContent: true

                mouseArea.onClicked: {
                    analysis_cfg_measType.value = analysis_cfg_measType.enums.emtOrl
                    upperRow.resetResultText()
                }
            }
            CheckTextButton {
                height: parent.height
                width: parent.width / 4
                checked: analysis_cfg_measType.value === analysis_cfg_measType.enums.emtReflect

                text: analysis_res_reflectBtnLabel.value
                centerContent: true

                mouseArea.onClicked: {
                    analysis_cfg_measType.value = analysis_cfg_measType.enums.emtReflect
                    upperRow.resetResultText()
                }
            }

            CheckTextButton {
                height: parent.height
                width: parent.width / 4
                checked: analysis_cfg_measType.value === analysis_cfg_measType.enums.emtSlope

                text: analysis_res_slopeBtnLabel.value
                centerContent: true

                mouseArea.onClicked: {
                    analysis_cfg_measType.value = analysis_cfg_measType.enums.emtSlope
                    upperRow.resetResultText()
                }
            }
        }
    }

    
    RowLayout {
        id: methodComboBoxItem
        visible: analysis_cfg_measType.value === analysis_cfg_measType.enums.emtLoss
        anchors.top: buttonRow.bottom
        anchors.bottom: parent.bottom
        anchors.left:  parent.left
        anchors.leftMargin: ViaviStyle.layouts.largeMargin
        //width: parent.width * 0.
        Text {
            id: methodComboBoxText
            Layout.fillWidth: true
            Layout.fillHeight: true
            horizontalAlignment : Text.AlignHCenter
            verticalAlignment : Text.AlignVCenter
            //wrapMode : Text.Wrap
            text: analysis_res_methodTextLabel.value + ':'
            font: ViaviStyle.layouts.largeFont
            color: ViaviStyle.colors.mainInfoColor
        }
        FiberComboBox {
            Layout.fillWidth: true
            //Layout.fillHeight: true
            model: analysis_res_methodList.value
            textRole: 'text'
            onCurrentIndexChanged: analysis_cfg_selectedMethod.value = currentIndex
            Component.onCompleted: currentIndex = analysis_cfg_selectedMethod.value
        }
    }

        // Remove result information for now, leave placeholder for it 
        RowLayout {
            id: itemResult
            visible: true
            anchors.top: buttonRow.bottom
            anchors.bottom: parent.bottom
            anchors.left:  methodComboBoxItem.visible === true ? methodComboBoxItem.right : parent.left
            anchors.leftMargin: ViaviStyle.layouts.largeMargin
            anchors.right: calculateButton.left
            anchors.rightMargin: ViaviStyle.layouts.largeMargin
            height: analysisResultValue.contentHeight
            Text {
                id: analysisResultValue
                Layout.fillWidth: true
                Layout.fillHeight: true
                fontSizeMode : Text.Fit
                text: analysis_res_resultTextLabel.value
                verticalAlignment : Text.AlignVCenter
                wrapMode : Text.Wrap
                font: ViaviStyle.layouts.numericValueFont
                color: ViaviStyle.colors.mainInfoColor
            }

            Text {
                Layout.fillWidth: true
                Layout.fillHeight: true
                fontSizeMode : Text.Fit
                text: analysis_res_resultUnitTextLabel.value
                font: ViaviStyle.layouts.numericConfigFont
                color: ViaviStyle.colors.mainInfoColor
            }
        }

    FiberButton {
        id: calculateButton
        anchors.right: parent.right
        anchors.rightMargin: ViaviStyle.layouts.largeMargin
        anchors.bottom: parent.bottom
        anchors.bottomMargin: ViaviStyle.layouts.mediumMargin
        width: ViaviStyle.layouts.buttonHeight * 4
        height: ViaviStyle.layouts.buttonHeight
        text: analysis_res_calculateBtnLabel.value

        onClicked: {
            analysis_act_calculate.invoke()
        }
    }
}