<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2015. All rights reserved.
// *********************************************************
namespace app\util;

/**
 * KML parsing exceptions
 * 
 * @author Sylvain Desplat
 *
 */
class SMTKmlException extends SMTException
{       
    const FILE_NOT_FOUND = "FILE_NOT_FOUND";    
    const INVALID_FILE = "INVALID_FILE";
    const NO_LINE_STRING = "NO_LINE_STRING";
    const TOO_MANY_LINE_STRING = "TOO_MANY_LINE_STRING";
    const NO_LINE_STRING_COORDINATES = "NO_LINE_STRING_COORDINATES";
    const NO_PLACEMARK = "NO_PLACEMARK";
    const COULD_NOT_CREATE_GPS_FILE = "COULD_NOT_CREATE_GPS_FILE";
    
    /**
     *
     * @param string $code error code
     * @param string $message detailed message
     */    
    function __construct( $code = NULL, $message = NULL )
    {
    	parent::__construct( $code, $message );
    }
    
    /**
     * Get error codes label for tracing without error codes.
     *
     * @return string
     */
    public function getErrorLabel()
    {
    	return $this->getErrorCode();
    }
        
    /**
     * Translates status code. If the code is not found, returns an empty string.
     *
     * @param string $code The status code to translate
     *
     * @return string the status message or an empty string if the status couldn't be found.
     */
    public function decodeMessage( $code )
    {
    	$message = MSG_ERROR_COULD_NOT_CREATE_FILE.$code;
    
    	switch( $code )
    	{
	    	case self::FILE_NOT_FOUND:
	    		$message = MSG_ERROR_FILE_NOT_FOUND;
	    		break;    	    	
    	    case self::COULD_NOT_CREATE_GPS_FILE:
    	    	$message = MSG_ERROR_COULD_NOT_CREATE_FILE;
    	    	break;    		 
    		case self::INVALID_FILE:
    		    $message = MSG_ERROR_INVALID_FILE;
    		    break;
		    case self::NO_LINE_STRING:
		    	$message = MSG_ERROR_NO_LINE_STRING;
		    	break;
	    	case self::TOO_MANY_LINE_STRING:
	    		$message = MSG_ERROR_TOO_MANY_LINE_STRING;
	    		break;
    		case self::NO_LINE_STRING_COORDINATES:
    			$message = MSG_ERROR_NO_LINE_STRING_COORDINATES;
    			break;
			case self::NO_PLACEMARK:
				$message = MSG_ERROR_NO_PLACEMARK;
				break;
			case self::COULD_NOT_CREATE_GPS_FILE:
				$message = MSG_ERROR_COULD_NOT_CREATE_GPS_FILE;
				break;
    		    
	    	default:
	    		break;
    	}
    	return $message;
    }
}

?>