<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\services\maintenance;

use app\util\SMTRwDto;

/**
 * DTO to query or update info on OTU
 *
 * @author Sylvain Desplat
 */
class SMTTestIpDto extends SMTRwDto
{
	/**
	 * Query or command to send to OTU
	 *
	 * @var string
	 */
	protected $command;

	/**
	 * Whether the command is a query (or not: OTU command)
	 *
	 * @var boolean
	 */
	protected $isQuery = TRUE;


	/**
	 * Whether the OTU port must be used
	 * @var boolean
	 */
	protected $isOtuPort = TRUE;


	/**
	 * The port to use (NULL by default if Otu port must be used)
	 * @var integer
	 */
	protected $port;
	
	/**
	 * The FO port (NULL by default)
	 * @var integer
	 */
	protected $portFO;

	/**
	 * Command or query result
	 *
	 * @var string
	 */
	protected $result;

	/**
	 * Command or query OTU ESR result
	 *
	 * @var string
	 */
	protected $esrCode;

	/**
	 * Whether command or query was successsfull
	 *
	 * @var boolean
	 */
	protected $success;

	/**
	 * Whether the command is a query (or not: OTU command)
	 * @param boolean $isQuery
	 */
	public function setQuery( $isQuery )
	{
		$this->isQuery = $isQuery;
	}

	/**
	 * Whether the command is a query (or not: OTU command)
	 * @return boolean
	 */
	public function isQuery()
	{
		return $this->isQuery;
	}

	/**
	 * Query or command to send to OTU
	 *
	 * @param string
	 */
	public function setCommand( $command )
	{
		$this->command = $command;
	}

	
	/**
	 * FO port
	 *
	 * @param int
	 */
	public function setPortFO( $portFO )
	{
		$this->portFO = $portFO;
	}	
	
	/**
	 * Query or command to send to OTU
	 *
	 * @return string
	 */
	public function getCommand()
	{
		return $this->command;
	}

	/**
	 * Command or query result
	 * @param string
	 */
	public function setResult( $result )
	{
		$this->result = $result;
	}

	/**
	 * Command or query OTU ESR result
	 * @param string
	 */
	public function setEsrCode( $esrCode )
	{
		$this->esrCode = $esrCode;
	}

	/**
	 * Whether command or query was successsfull
	 * @param boolean
	 */
	public function setSuccess( $success )
	{
		$this->success = $success;
	}

	/**
	 * @param boolean $valid
	 */
	public function isOtuPort()
	{
		return $this->isOtuPort;
	}

	/**
	 * @return integer
	 */
	public function getPort()
	{
		return $this->port;
	}

	/**
	 * Serialize as Json data (array) the user object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json array.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties );
		return $objectProperties;
	}

	/**
	 * Returns Dto class name.
	 *
	 * @return string the dtop class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}

	/**
	 * Create the Dto from a Json Dto in an array
	 *
	 * @param array $json_array json data in an array
	 *
	 * @return \app\\services\\maintenance\SMTTestIpDto
	 */
	static function getInstance( array &$json_array )
	{
		return self::forge( get_class(), $json_array );
	}
}


?>