<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\services\maintenance;

use app\util\SMTDto;
use app\util\SMTLogger;

/**
 * DTO with the list of log files
 * 
 * @author Sylvain Desplat
 */
class SMTLogFilesDto extends SMTDto
{
    /**
     * log files names that can be downloaded
     * 
     * @var array
     */
	protected $logfilesNames;
	
	/**
	 * SmartOTU log level
	 */
	protected $logLevel = SMTLogger::INFO;
	
	/**
	 * The log files names that can be downloaded
	 * 
	 * @param array $logfilesNames
	 */
	public function setLogFilesNames( array &$logfilesNames )
	{
		$this->logfilesNames = $logfilesNames;
	}
	
	/**
	 * The log files names that can be downloaded
	 *
	 * @return array
	 */
	public function getLogFilesNames()
	{
		return $this->logfilesNames;
	}

	/**
	 * @param $logLevel string
	 */
	public function setLogLevel( $logLevel )
	{
		return $this->logLevel = $logLevel;
	}
	
	/**
	 * Returns the smartOTU log level: INFO, ERROR
	 * @return boolean
	 */
	public function getLogLevel()
	{
		return $this->logLevel;
	}
	
	/**
	 * Serialize as Json data (array) the user object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json array.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties );
		return $objectProperties;
	}

	/**
	 * Returns Dto class name.
	 *
	 * @return string the dtop class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}
}


?>