<?php

// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2013. All rights reserved.
// *********************************************************
namespace app\events;

use app\events\activity\SMTActivityMessageEventDto;

use app\services\activity\SMTActivityDto;

use app\services\alarm\SMTAlarmDto;

use app\events\alarms\SMTSystemAlarmMessageEventDto;

use app\events\alarms\SMTOpticalAlarmMessageEventDto;



use app\services\alarm\SMTAttenuationOpticalAlarmDto;

use app\serviceshelper\monitoring\SMTMeasureOnDemandEventDto;

use app\serviceshelper\monitoring\SMTTestOnDemandEventDto;

use app\events\linktest\SMTLinkTestUpdateEventDto;

use app\services\monitoring\SMTLinkTestDto;

use app\services\alarm\otu\SMTOtuOpticalAlarmDto;
use app\services\alarm\otu\SMTOtuSystemAlarmDto;
use app\services\alarm\SMTPeakOpticalAlarmDto;
use app\services\monitoring\SMTCurrentPortDto;
use app\services\alarm\otu\SMTOtuAlarmDto;

/**
 * Utility class to create events for the messages package
 * 
 * @author Sylvain Desplat
 */
class SMTEventFactory
{
    /**
     * Create a link-test update event from the given link-test DTO.
     * 
     * @param SMTLinkTestDto $linkTest $linkTest can be null when asking an update of all the link-tests ($isRefreshAll = TRUE)
     * @param boolean $isDeleted Whether the given link-test is being deleted ( the link + the test)
     * @param boolean $isRefreshAll Whether all the link-tests must be refreshed.
     * @param int $currentPort the current selected port if an external switch not managed by OTU is used or -1 by default
     * @return \app\events\linktest\SMTLinkTestUpdateEventDto
     */
    public static function createLinkTestUpdateEvent( SMTLinkTestDto $linkTest = NULL, 
                                                      $isDeleted = FALSE, 
                                                      $isRefreshAll = FALSE, 
    		                                          $currentPort = SMTCurrentPortDto::INVALID_CURRENT_PORT)
    {
        $event = new SMTLinkTestUpdateEventDto();
        
        if ( $isRefreshAll ) 
        {
            $event->setRefreshAll( $isRefreshAll );
            $event->setCurrentPort($currentPort);
        }
        else
        {
        	$event->setLinkTest($linkTest);
        	$event->setIsDeleted( $isDeleted );
        	$event->setCurrentPort($currentPort);
        }            

        return $event;
    }
       
    /**
     * Create an alarm event from the given alarms DTO.
     *
     * @param SMTAlarmDto $alarm
     * @return \app\events\SMTEventDto
     */
    public static function createAlarmEvent( $alarms, SMTOtuAlarmDto $otuAlarm /*SMTAlarmDto $alarm*/ )
    {
    	$event = NULL;
    	if ( $otuAlarm instanceof SMTOtuOpticalAlarmDto)
    	{
    		$event = new SMTOpticalAlarmMessageEventDto();
    	}
    	else if ( $otuAlarm instanceof SMTOtuSystemAlarmDto)
    	{
    		$event = new SMTSystemAlarmMessageEventDto();
    	}
    	
    	foreach($alarms as $alarm)
    	{
    		if (($alarm != NULL) && ($event != NULL))
    		{
    			if ( $event instanceof SMTOpticalAlarmMessageEventDto)
    			{
    				if ($alarm instanceof SMTAttenuationOpticalAlarmDto)
    				{
    					$event->setAttenuationAlarm( $alarm );
    				}
    				else if ($alarm instanceof SMTPeakOpticalAlarmDto)
    				{
    					$event->addPeakOpticalAlarm( $alarm );
    				}
    			}
    			if ( $event instanceof SMTSystemAlarmMessageEventDto)
    			{
    				$event->setSystemAlarm( $alarm );
    			}
    		}
    	}
        
    	return $event;
    }    
    
    /**
     * Create an alarm event to notify that a refresh of all optical alarms should be performed.
     *
     * @return \app\events\alarms\SMTOpticalAlarmMessageEventDto
     */
    public static function createRefreshAllOpticalAlarmEvent()
    {    
    	return new SMTOpticalAlarmMessageEventDto();
    }  
    
    /**
     * Create an alarm event to notify that a refresh of all system alarms should be performed.
     *
     * @return \app\events\alarms\SMTSystemAlarmMessageEventDto
     */
    public static function createRefreshAllSystemAlarmEvent()
    {   
    	return new SMTSystemAlarmMessageEventDto();
    }    
    
    /**
     * Create an otu activity event from the given activity DTO.
     *
     * @param SMTActivityDto $activity
     * @return \app\events\SMTEventDto
     */
    public static function createActivityEvent( SMTActivityDto $activity )
    {
		$event = new SMTActivityMessageEventDto();
		$event->setActivity( $activity  );
    	return $event;
    }
    
    /**
     * Create a test on demand default event from the given parameters
     * 
     * @param String $testId
     * @param String $operationId
     * @param String $status
     * @return \app\serviceshelper\monitoring\SMTTestOnDemandEventDto
     */
    public static function createTestOnDemandEvent( $testId, $operationId, $status )
    {
    	$event = new SMTTestOnDemandEventDto();
    	$event->setOperationId( $operationId );
    	$event->setTestId( $testId );
    	$event->setStatus($status);
    	return $event;
    }
    
    /**
     * Create a measure on demand default event from the given parameters
     *
     * @param String $linkId can be NULL
     * @param String $operationId
     * @param String $status
     * @return \app\serviceshelper\monitoring\SMTMeasureOnDemandEventDto
     */
    public static function createMeasureOnDemandEvent( $linkId, $operationId, $status )
    {
    	$event = new SMTMeasureOnDemandEventDto();
    	$event->setOperationId( $operationId );
    	$event->setLinkId($linkId);
    	$event->setStatus($status);
    	return $event;
    }


}
?>