<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2015. All rights reserved.
// *********************************************************
namespace app\database\patch;

use app\util\SMTLogger;

use app\database\SMTSmartOtuDB;

use app\database\SMTSqlPatch;

/**
 * Datatabase patch to add GPS coordinates in attenuation optical alarm
 * Database version 1
 * Patch number 4
 *
 * @author Sylvain Desplat
 */
class SMTSql01p0004 extends SMTSqlPatch
{  
//patches:
    const SQL_ADD_ALARM_GPS_X_COLUMN =
    "ALTER TABLE attenuation_optical_alarm_event ADD gps_x REAL DEFAULT 0";
    const SQL_ADD_ALARM_GPS_Y_COLUMN =
    "ALTER TABLE attenuation_optical_alarm_event ADD gps_y REAL DEFAULT 0";
    const SQL_ADD_ALARM_GPS_VALID_COLUMN =
    "ALTER TABLE attenuation_optical_alarm_event ADD gps_valid INTEGER NOT NULL DEFAULT FALSE";
    
    
    function __construct()
    {
        SMTLogger::getInstance()->trace( sprintf("Execute patch %s.", __CLASS__ ), SMTLogger::INFO );
        
    	//retrieve patch version
        $className = basename(__FILE__, '.php');
        preg_match_all('!\d+!', $className, $matches);
        
        $this->dbVersion = $matches[0][0];
        $this->dbPatch = $matches[0][1];    	
    }
    
    /**
     * @return SMTSql01p0004
     */    
    public static function getInstance()
    {
        return new SMTSql01p0004();
    }
    
    /**
     * Add smartOTU system_configuration table.
     *
     * @see \app\database\SMTSqlPatch::execute()
     */    
    public function execute( SMTSmartOtuDB $db )
    {    
    	$query = self::SQL_ADD_ALARM_GPS_X_COLUMN;
    	$success = $db->execWithTrace($query, SMTLogger::INFO );    
    	self::handleExecutePatchError($db, $query, $success, __FILE__, __METHOD__, __LINE__ );

    	$query = self::SQL_ADD_ALARM_GPS_Y_COLUMN;
    	$success = $db->execWithTrace($query, SMTLogger::INFO );
    	self::handleExecutePatchError($db, $query, $success, __FILE__, __METHOD__, __LINE__ );
    	
    	$query = self::SQL_ADD_ALARM_GPS_VALID_COLUMN;
    	$success = $db->execWithTrace($query, SMTLogger::INFO );
    	self::handleExecutePatchError($db, $query, $success, __FILE__, __METHOD__, __LINE__ );
    	
	    $success = $this->addPatchTrace($db, 'Add GPS coordinates in alarm');
	    self::handleExecutePatchError($db, SMTSqlPatch::SQL_TRACE_DATABASE_PATCH, $success, __FILE__, __METHOD__, __LINE__ );    	
    }
}
?>