import QtQuick 2.1
import QtQuick.Layouts 1.0

import common 1.0

BorderImage { id: cursorValue

    property int index: -1
    property alias text: value.text
    property alias color: value.color
    property alias font: value.font
    property string imageSource: ""

    property bool largeFont: false

    border { left: 8; right: 8; top: 0; bottom: 0 }
    height: 30
    smooth: false

    property string __position: {
        var rw = Math.round(width);
        var rx = Math.round(x);
        var rpw = Math.round(parent.width);
        if (rw == rpw)
            return "bottom";
        else if (rx == 0)
            return "left"
        else if (rx+rw == rpw)
            return "right"
        return "center"
    }
    source: theme.dynamicDirPrefix + "cursor-label-" + __position

    Row
    {
        anchors.centerIn: parent
        spacing: 5

        Image
        {
            id: valueImage
            height: cursorValue.imageSource === "" ? 0 : 16
            width: cursorValue.imageSource === "" ? 0 : 16
            visible: cursorValue.imageSource !== ""
            source: cursorValue.imageSource
        }

        Text { id: value
            font: largeFont ? systemFont.LargeTitleFont : systemFont.HeaderFont
            color: "#000000"
            smooth: false
            text: valueImage.width
        }
    }

    Layout.minimumWidth: value.width + valueImage.width + 8
    Layout.fillWidth: true
}
