#!/usr/bin/env bash
# OSB is a 2k/4k module with PCIe feature on SLOTA/PWRS
# It is seen as module 4 because of hardware configuration

init-osb_init()
{
	# Is the OSB present
	qdbus --literal --system com.viavisolutions.platform.SystemInventory /com/viavisolutions/platform/SystemInventory/4 com.viavisolutions.platform.SystemInventory.ModuleResources.SystemRecords | grep -q "703100B01-"
	[ $? -ne 0 ] && echo "No OSB found, aborting" && return 1

	# Ensure it is powered on
	dbus-send --system --type=method_call --dest=com.viavisolutions.platform.PowerBudget /com/viavisolutions/platform/PowerBudget com.viavisolutions.platform.PowerBudget.RequestModulePowerOn uint32:4

	# Do not programm in pmulti
	if grep -q /dev/mmcblk0 /proc/cmdline ; then
		# Check if fpga bitstream have to be upgraded
		/usr/bin/advisordff ste1 -sf 4 /usr/share/firmware/osb/osb.bin

		ADVISOR_DFF_RESULT_CODE=$?
		if [ $ADVISOR_DFF_RESULT_CODE -eq 0 ] ; then
			echo "fpga bitstream updated, need to reboot."
			[ -f /sbin/otu_confirm_start.sh ] && /sbin/otu_confirm_start.sh
			reboot
			return 2
		elif [ $ADVISOR_DFF_RESULT_CODE -eq 11 ] ; then
			echo "FPGA bitstream up to date."
		else
			echo "advisordff returned unexpected result, continuing anyway."
		fi

		# Select the module
		echo "0x00000081" > /sys/platform/msel_osb/register_msel
		echo "0x000000A1" > /sys/platform/msel_osb/register_msel
		echo "0x00000000" > /sys/platform/msel_osb/register_msel
	fi

	# Set Module in OTDR mode (required for interrupt)
	/usr/bin/hamma action.write port.moduleSelector.MODULE_SEL value.0x02
}
