init-tacb_init()
{
	isTACBUpdated[1]=-1
	isTACBUpdated[2]=-1

	# TACB management
	#
	# Search for HETNET modules in position 1 or 2 and look for a TACB
	# For each module found, load it's overlay
	for i in `seq 1 2`;
	do
	qdbus --literal --system com.viavisolutions.platform.SystemInventory /com/viavisolutions/platform/SystemInventory/$i com.viavisolutions.platform.SystemInventory.ModuleResources.SystemRecords | grep -q "703100B10-"
	if [ $? -eq 0 ]
	then
		echo "TACB found at address $i"

		# Program the TACB fpga if needed
		load_tacb_fpga.sh ${i}
		isTACBUpdated[$i]=$?

		# If the TACB has been updated, we can't handle the submodule behind it - We simply restart
		if [[ "${isTACBUpdated[$i]}" != "0" ]]
		then
			SYS_PLATFORM_DIR="/sys/platform_m$i"

			# Set all power
			echo "0xFFFFFFFF" > "${SYS_PLATFORM_DIR}/powersupply/all"

			sleep 0.1

			# Program "generic" fpga for the module under the TACB
			load_tacb_submodule_fpga.sh ${i}

			sleep 0.1
			# Select the module, module can be selected all the time in a TACB
			echo "0x00000081" > "${SYS_PLATFORM_DIR}/msel/register_msel"
			echo "0x000000A1" > "${SYS_PLATFORM_DIR}/msel/register_msel"
			echo "0x00000000" > "${SYS_PLATFORM_DIR}/msel/register_msel"
		fi
	fi
	done

	if   [[ "${isTACBUpdated[1]}" -eq "0" ]] \
	  || [[ "${isTACBUpdated[2]}" -eq "0" ]]
	then
		echo "A TACB has been updated - Reboot in 5 seconds"

		# Simulate Otu launch to avoid rebooting in rescue mode - if script exists
		[ -f /sbin/otu_confirm_start.sh ] && otu_confirm_start.sh

		sleep 5

		reboot
		exit -1
	fi
}

init-tacb_init_post()
{
	# Apply post op on fpga (programming the specific bitstream for the module under the TACB)
	for i in `seq 1 2`;
	do
		qdbus --literal --system com.viavisolutions.platform.SystemInventory /com/viavisolutions/platform/SystemInventory/$i com.viavisolutions.platform.SystemInventory.ModuleResources.SystemRecords | grep -q "703100B10-"
		if [ $? -eq 0 ]
		then
			CFG_FILE=$(grep -E "^2[[:space:]]$((i - 1))" /sys/platform/uts_scan/modules | tr -s "\t" | cut -f6 | tr -d " ")
			if [ -n "$CFG_FILE" ]
			then
				SVF_FILE=/acterna/storage/fpga/"${CFG_FILE%.cfg}.svf"
				if [ -e "${SVF_FILE}" ]
				then
					load_tacb_submodule_fpga.sh ${i} "${SVF_FILE}"
					SYS_PLATFORM_DIR="/sys/platform_m${i}"
					sleep 0.1
					# Select the module, module can be selected all the time in a TACB
					echo "0x00000081" > "${SYS_PLATFORM_DIR}/msel/register_msel"
					echo "0x000000A1" > "${SYS_PLATFORM_DIR}/msel/register_msel"
					echo "0x00000000" > "${SYS_PLATFORM_DIR}/msel/register_msel"
				else
					echo "Specific bitstream not found, was searching for ${SVF_FILE}"
				fi
			fi
		fi
	done
}

init-tacb_deinit()
{
	# Search for ALE module (position 1 or 2) if there is a tacb
	# For each TACB detected - de-init what is needed
	for i in `seq 1 2`;
	do
	qdbus --literal --system com.viavisolutions.platform.SystemInventory /com/viavisolutions/platform/SystemInventory/$i com.viavisolutions.platform.SystemInventory.ModuleResources.SystemRecords | grep -q "703100B10-"
	if [ $? -eq 0 ] ; then
		echo "TACB module found at module $i"

		# Stop the network interface
		ifconfig eth_M$i down

		# Reset all power
		# The sequence we follow is there to ensure the different voltages are shutdown in the correct order
		# The goal of this sequence is to avoid the bug with the U90 component on the 6k/8k modules
		# 1 - Cut off CLK80M
		echo "0xFFFCFFFF" > "/sys/platform_m$i/powersupply/all"
		# 2 - Shutdown every voltages but 3V3
		echo "0x00000008" > "/sys/platform_m$i/powersupply/all"
		# 3 - Shutdown 3V3
		echo "0x00000000" > "/sys/platform_m$i/powersupply/all"

		# Shutdown the Zynq
		echo "0" > "/sys/platform_m$i/zynq_hw_reset_n/value"
		# Waiting for the Zynq to take into account the reset signal
		sleep 4
	fi
	done
}
