#!/bin/bash

USER_NAME_TO_REMOVE=(eotdr fth9000 fth7000 utility upgeotdr sma)
BACKUP_FILE_PASSWD=/etc/password_removed
BACKUP_FILE_SHADOW=/etc/shadow_removed

ROOT_ACCESS="$(fw_printenv root_access | cut -f2 -d= )"
ENH="$(fw_printenv Enhanced_Security | cut -f2 -d= )"
SMARTOTUGUESTUSER="smartotuguest"

create_smartotuguest_user () {
    #  Create smartotuguest usergroup and add smartotuguest user into the group
    #    No user login shell and no home directory for the smartotuguset user 
    [ -z $(grep smartotuguest /etc/group) ] && groupadd smartotuguest
    useradd --shell /bin/false -M -g smartotuguest --password='''$1$CYeL58Gp$koKqR3CE7d/3JaT8ZZ5s0/''' smartotuguest

    #  add guest alias for smartotuguest in /etc/aliases
    # [ -z $(grep "\:smartotuguest$" /etc/aliases) ] &&  echo "guest:smartotuguest" >> /etc/aliases
}

delete_smartotugguest_user () {
    #  remove smartotuguest
    userdel -f smartotuguest > /dev/null 2>&1

    #  remove the guest alias from /etc/aliases
    [ ! -z $(grep "\:smartotuguest$" /etc/aliases) ] &&  sed -i '/:smartotuguest$/d' /etc/aliases
}

if [[ "$ENH" == "true" ]] ; then
    # backup user to removed
    if [ ! -s ${BACKUP_FILE_PASSWD} ] ; then
        GREP_STR=$(echo ${USER_NAME_TO_REMOVE[@]/%/:} | tr ' ' '|')
        grep -E ${GREP_STR} /etc/passwd > ${BACKUP_FILE_PASSWD}
        grep -E ${GREP_STR} /etc/shadow > ${BACKUP_FILE_SHADOW}
    fi
    # Remove users for enhanced security
    for i in ${USER_NAME_TO_REMOVE[@]}; do
        if id ${i} > /dev/null 2>&1 ; then
            # Delete the user even if it has running process
            userdel -f ${i} > /dev/null 2>&1
        fi
        [ "${i}" == "$SMARTOTUGUESTUSER" ] && [ ! -z $(grep "\:smartotuguest$" /etc/aliases) ] &&  sed -i '/:smartotuguest$/d' /etc/aliases
    done
    if [[ "${ROOT_ACCESS}" != "true" ]] ; then
        id secuser 2>&1 > /dev/null
        if [[ $? -ne 0 ]] ; then
            # Recreate secuser : needed for onmsi if no root access license
            /usr/sbin/create_secuser.sh
        fi

        id smartotuguest 2>&1 > /dev/null
        if [[ $? -ne 0 ]] ; then
            # Recreate smartotuguest
            create_smartotuguest_user
        fi
    else
        # root access license : remove secuser
        id secuser 2>&1 > /dev/null
        if [[ $? -eq 0 ]] ; then
            userdel -f secuser > /dev/null 2>&1
        fi

        # root access license : remove smartotuguest
        id smartotuguest 2>&1 > /dev/null
        if [[ $? -eq 0 ]] ; then
            delete_smartotugguest_user
        fi
    fi
else
     # Try to restore user as they used to be
    if [[ -f ${BACKUP_FILE_PASSWD} ]] ; then
        cat ${BACKUP_FILE_PASSWD} >> /etc/passwd
        cat ${BACKUP_FILE_SHADOW} >> /etc/shadow
        rm ${BACKUP_FILE_PASSWD}
        rm ${BACKUP_FILE_SHADOW}
    fi
    # if not root_access license, we need secuser, ensure that
#    if [[ "${ROOT_ACCESS}" != "true" ]] ; then
        id secuser 2>&1 > /dev/null
        if [[ $? -ne 0 ]] ; then
            # Recreate secuser
            /usr/sbin/create_secuser.sh
        fi

        id smartotuguest 2>&1 > /dev/null
        if [[ $? -ne 0 ]] ; then
            # Recreate smartotu
            create_smartotuguest_user
            # /usr/sbin/create_smartotu_guest.sh
        fi
#    fi
fi

if [ `grep smartotu: /etc/group | wc -l` == 0 ];
then
   groupadd smartotu
fi
if [ `grep smartotu: /etc/shadow | wc -l` == 0 ];
then
   useradd -d /usr/share/apache2/htdocs -p \\\$1\\\$lyAU2uvD\\\$He7fcR4c8rwL6ImTs0sR3/ -r -s /bin/bash smartotu -g smartotu
fi
if [ `grep ntp: /etc/shadow | wc -l` == 0 ];
then
   useradd --system --home-dir /var/lib/ntp --no-create-home --shell /bin/false -g 993 ntp
fi

exit 0
