#!/bin/sh

usage () {
        echo "usage:  $0 \"temporary_public_key_file\""
        exit 1
}

echo "keys: $1"
authorized_file="/root/.ssh/authorized_keys"


#  Enable logging by uncommenting the next 2 lines
SSH_VALIDATION_LOG_LOCATION="/var/log"
exec >> $SSH_VALIDATION_LOG_LOCATION/sanitize-extract-ssh-keys.log 2>&1

STATUS=1
COUNT_EXTRACTED_KEYS=0
DEFAULT_ROOTKEY_LOC="/root/.ssh/default_root_key_4096.pub"
OTU_ROOTKEY_VERIF_LOC="/usr/lib/jdsu/scripts/otu_verify_viavidefkey.sh"

#  Check if the input file to this script is missing or not specified
if [ $# -ne 1 ];
then
    echo "-->"
    echo "$0 $(date '+%d/%m/%Y %H:%M:%S') -- Input File Not Specified"
    echo ""
    echo ""
    exit 1
else 
    if [ ! -f "$1" ]
    then
        echo "-->"
        echo "$0 $(date '+%d/%m/%Y %H:%M:%S') --   Input File $1 Not Found"
        echo ""
        exit 1
    fi 
fi


# Local files used by the script
loc_extr_key='/tmp/temp.pub'
loc_sanitized_public_keys='/tmp/sanitized_public_keys'

echo "-->"

[[ -f "$loc_extr_key" ]] && rm -f $loc_extr_key
[[ -f "$loc_sanitized_public_keys" ]] && mv $loc_sanitized_public_keys $loc_sanitized_public_keys.$(date +%Y%m%d%H%M%S)

NUM_ENTRIES_INPUT_FILE=$(echo $1 | wc -l)
echo "NUM_ENTRIES_INPUT_FILE = $NUM_ENTRIES_INPUT_FILE"

if [ $NUM_ENTRIES_INPUT_FILE -gt 0 ]; then
  #  Vet each entry of the Input File to isolate and retrieve valid SSH public key
  echo "$0 $(date '+%d/%m/%Y %H:%M:%S') -- Input file $1 contains mixed payload"

  #  Extract valid SSH keys and store them in
  #  temporrary authorized_keys 
  while IFS= read -r line
  do
      #  Extract each payload entry individually
      #  and test if it is an SSH public key
      echo "$line" > $loc_extr_key
      ssh_key_extracted_from_input_file=$(ssh-keygen -lf  $loc_extr_key 2> /dev/null)

      #  Save the entry if it is a  valid SSH public key
      if [[ ! -z $ssh_key_extracted_from_input_file ]]; then
          # echo "extracted SSH Key = $(cat $loc_extr_key)"
          cat $loc_extr_key >> /$loc_sanitized_public_keys
          COUNT_EXTRACTED_KEYS=$(($COUNT_EXTRACTED_KEYS + 1))
      fi 
      [[ -f "$loc_extr_key" ]] && rm -f $loc_extr_key
  done <"$1"
  
  if [[ $COUNT_EXTRACTED_KEYS -gt 0 ]]; then
      STATUS=0
      echo "$0 $(date '+%d/%m/%Y %H:%M:%S') --  $COUNT_EXTRACTED_KEYS SSH public keys extracted to $loc_sanitized_public_keys"``

      if [ -f $OTU_ROOTKEY_VERIF_LOC ] && [ -f $DEFAULT_ROOTKEY_LOC ]; then
	      echo "$0 $(date '+%d/%m/%Y %H:%M:%S') --  Vetting SSH Edit Key Selection for the default root key"
	      /usr/lib/jdsu/scripts/otu_verify_viavidefkey.sh  CLRDEF $DEFAULT_ROOTKEY_LOC  $loc_sanitized_public_keys
      fi

      cat "$loc_sanitized_public_keys" > "$authorized_file"
      STATUS=`echo $?`
      chmod 600 $authorized_file

      echo "result: $STATUS"
  else
      STATUS=1
      echo "$0 $(date '+%d/%m/%Y %H:%M:%S') --  Input File $1 does not contain valid SSH Public Keys"
  fi
  
  echo ""
else
    
    echo "$0 $(date '+%d/%m/%Y %H:%M:%S') --   Input file $1 is empty"
    echo ""
    STATUS=1
fi

  [[ -f "$1" ]] && rm -f $1
  [[ -f "$loc_extr_key" ]] && rm -f $loc_extr_key
  [[ -f "$loc_sanitized_public_keys" ]] && rm -f $loc_sanitized_public_keys
  
exit $STATUS
