#!/bin/sh

RESULT=0

PLATFORM="$(tr -d '\0' < /proc/device-tree/model)"
if [ $PLATFORM == "oth" ]; then
    # Journalctl rotates current logs and erases logs older than 1s
    journalctl --rotate --vacuum-time=1s
    RESULT=$(($RESULT+$?))
elif [ $PLATFORM == "eotdrv2" || $PLATFORM == "mts8000v2" ]; then
    # Stop syslog daemon
    /etc/init.d/syslog stop
    RESULT=$(($RESULT+$?))
else
    echo "ERROR - PLATFORM NOT HANDLED"
fi

# Erase log
rm -rf /var/log/*
RESULT=$(($RESULT+$?))

echo "result: $RESULT"
exit $RESULT

