#!/bin/sh

do_start() {
   /usr/bin/update_otu_sysoids.sh

   # Start the services (for the current boot only)
   /bin/systemctl start snmpd
   /bin/systemctl start snmp-agent
   /bin/systemctl start snmptrapd
}

do_stop() {
   # Stop the services (for the current boot only)
   /bin/systemctl stop snmp-agent
   /bin/systemctl stop snmpd
   /bin/systemctl stop snmptrapd
}

case "$1" in
    start)
        do_start
        ;;
    stop)
        do_stop
        ;;
    restart)
        do_stop
        do_start
        ;;
    *)
        echo "Usage: /etc/init.d/snmp.sh {start|stop|restart}"
        exit 1
        ;;
esac

exit 0

