#! /bin/sh

GEN_FPGA="/acterna/storage/fpga/"
CABLE_NAME="cable tacb"
TMP_CMD="/tmp/cmd"
TMP_RES="/tmp/res"

RunJtagCmd() {
   case "$1" in
     expl)
	# Explore jtag chain
	echo $CABLE_NAME" interface="$Interface >  $TMP_CMD
	echo "detect"    >> $TMP_CMD
	jtag $TMP_CMD > $TMP_RES
	;;
     prog)
	# Prog
	echo $CABLE_NAME" interface="$Interface >  $TMP_CMD
	echo "detect"    >> $TMP_CMD
	echo "$2"        >> $TMP_CMD
        jtag $TMP_CMD > $TMP_RES
	;;
     *)
	echo "Error"
	;;
   esac
}

GetIdNumber() {
   grep "^Chain length:" "$TMP_RES" | cut -f2 -d':'
}

GetId() {
   grep "Device Id:" $TMP_RES | cut -f2 -d'(' | cut -f1 -d')' | head -n "$1" | tail -n 1 | tr '[:upper:]' '[:lower:]'
}

Interface=0
# Process arguments
if [ $# -ge 1 ] ; then
  Interface=$(($1 - 1))
fi

PROG_SPECIFIC=""
if [ $# -ge 2 ] ; then
  PROG_SPECIFIC=$2
fi

echo "TACB submodule ID #$Interface"
# Explore jtag chain
RunJtagCmd expl
# Program each component with a file named with the ID
# If we are in POST Operation do not program but execute post op instead
ComponentNumber=$(GetIdNumber)
ComponentNumber=$((ComponentNumber+0))
[ "$ComponentNumber" == "0" ] && echo "No ID" && exit 0
n=0
while [ $n != $ComponentNumber ]
do
  sleep 1
  n=$((n+1))
  echo -n "#"$n
  ID=$(GetId $n)
  echo -n " \"$ID\" "
  if [ -e "$GEN_FPGA/$ID" ]
  then
    if [ -z "$PROG_SPECIFIC"  ] ; then
      action=$(grep -v POSTSCAN_CMD "$GEN_FPGA/$ID")
      echo "Programming $ID"
      RunJtagCmd prog "$action"
    else
	    echo "Programming specific bitstream for $ID"
      action="svf $PROG_SPECIFIC"
      RunJtagCmd prog "$action"
    fi
  else
    echo "Bitstream not found for $ID"
  fi
done
