import QtQuick 2.3
import "./UtilUiQt/Viavi_Colors.js" as VColor
import libfo 1.0
import "./UtilUiQt"

Rectangle
{
   id: container
   
   property int current_idx_selected : wizardLoadConfig_cfg_selectedFileIndex.value
   property int items_margin: 10
   
   //color: VColor.cViaviColorLightGray2
   color: VColor.cViaviColorWhite
  
  ListView
  {
      id: list
      spacing: 0
      boundsBehavior: Flickable.StopAtBounds
      
      anchors.fill: parent
      anchors.topMargin: items_margin
      anchors.bottomMargin: items_margin

      highlightMoveVelocity: -1
      highlightMoveDuration: -1
      
      currentIndex: current_idx_selected

      clip: true
      focus: true
      
      onContentYChanged: indicator.value = parseInt(contentY, 10) * 100 / contentHeight;
      onHeightChanged: indicator.ratio = (indicator.height + items_margin)  * 100 / (contentHeight);
      onContentHeightChanged: indicator.ratio = (indicator.height + items_margin)  * 100 / (contentHeight);
      
      onCurrentIndexChanged: {
         current_idx_selected = currentIndex;
      }

      model: wizardLoadConfig_res_fileList.value
      delegate:  Rectangle {
                     id: delegateContainer
                     width: list.width
                     height: 50
                     
                     color: delegateContainer.ListView.isCurrentItem ? VColor.cViaviColorLogoPurple : "transparent"
                     
                     Text {      		
            		      anchors.left : parent.left
            		      anchors.leftMargin: delegateContainer.ListView.isCurrentItem ? 2*items_margin : items_margin
            		      
            		      anchors.verticalCenter: delegateContainer.verticalCenter
               	
                        color: delegateContainer.ListView.isCurrentItem ? VColor.cViaviColorWhite : VColor.cViaviColorBlack
                   
                        text: modelData
                        verticalAlignment: Text.AlignVCenter
   		               font.pixelSize: delegateContainer.ListView.isCurrentItem ? 20 : 16
   				         font.bold: delegateContainer.ListView.isCurrentItem
                     }
                     
                     Rectangle {
                        color: VColor.cViaviColorLightGray2
                        
                        anchors.bottom: delegateContainer.bottom
                        anchors.horizontalCenter: delegateContainer.horizontalCenter
                        
                        height: 1
                        width: delegateContainer.width * 0.90
                     }
                     
                     MouseArea {
                          anchors.fill: parent
                          onClicked: {
                           current_idx_selected = index;
                          }
                     }
                }
  }
  
  ViaviSlider {
     id: indicator
     width: (visible == true) ? 5 : 0
     orientation : Qt.Vertical
     enabled: false
     
     anchors.right: parent.right
     anchors.rightMargin: items_margin           
     anchors.top: list.top 
     anchors.bottom: list.bottom
     
     // visible: list.contentHeight >  list.height
     visible: false
     
     ratio: (list.height + items_margin)  * 100 / (list.contentHeight)
  }
}