import QtQuick 2.3
import "./UtilUiQt/Viavi_Colors.js" as VColor
import libfo 1.0
import "ViaviStyle"

Rectangle {
   id: container

   color: VColor.cViaviColorWhite

   Rectangle {
        id: title_banner
        width: parent.width
        height: 40
        color: VColor.cViaviColorGray
        anchors.top : parent.top
        
        Text {
            id: txtLoadMsgFile 
            width: parent.width - 40
            height: parent.height
            color: VColor.cViaviColorWhite
            anchors.centerIn: title_banner
            text: wizardWindowManager_res_txtLoadFileHeader.value
            
            verticalAlignment: Text.AlignVCenter
            horizontalAlignment: Text.AlignHCenter
            font.pixelSize: 18
            wrapMode: Text.Wrap
            }
        }

    Wizard_Load_Conf_Directory_Listview {
        id: listview
        
        enabled: wizardLoadConfig_res_canLoad.value;
        
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: title_banner.bottom
        anchors.bottom: buttonSelection.top
    }

   Rectangle {
       id: buttonSelection
       
       width: parent.width
       height: 70
       
       property int buttonWidth: buttonSelection.height * 1.5
       property int buttonHeight: buttonSelection.height
       property int textSize: 18
       property int buttonMargin: 10
       property int nbButtons: wizardWindowManager_res_canAskAssist.value ? 3 : 2

       color: VColor.cViaviColorLightGray2

       anchors.bottom: parent.bottom
       
       Rectangle {
         anchors.top: parent.top
         anchors.bottom: parent.bottom
         anchors.left: parent.left
         anchors.right: rowButtons.left
         anchors.rightMargin: 2
         
       
         color: VColor.cViaviColorGray
       
          Text {
            id: pathText
            
            anchors.fill: parent
            color: VColor.cViaviColorWhite
            
            anchors.left: parent.left
            anchors.leftMargin: 10
            anchors.verticalCenter: parent.verticalCenter
            
            text: wizardLoadConfig_res_pathLoaded.value
            verticalAlignment: Text.AlignVCenter
            horizontalAlignment: Text.AlignLeft
            font.pixelSize: 20
            font.italic: true
            wrapMode: Text.Wrap
            
            clip: true
          }
       }
       
       Row {
         id: rowButtons
         
         anchors.top: parent.top
         anchors.bottom: parent.bottom
         anchors.right: parent.right
         
         layoutDirection: Qt.RightToLeft
         
         spacing: 2
         
         Rectangle {
           id: cancelButton
           width: buttonSelection.buttonWidth
           height: buttonSelection.buttonHeight

           color: VColor.cViaviColorRed
           
           visible: wizardWindowManager_res_canAskAssist.value
           opacity: ( mouseAreaCancelButton.pressed ? 0.8 : 1 )
           
           Text {
               color: VColor.cViaviColorWhite
               anchors.fill: parent
               text: wizardWindowManager_res_txtCancelLoadingFile.value.toUpperCase()
               horizontalAlignment: Text.AlignHCenter
               verticalAlignment:  Text.AlignVCenter
               font.pixelSize: buttonSelection.textSize
           }

           MouseArea {
               id: mouseAreaCancelButton
               
               anchors.fill: parent
               onClicked: {
                  wizardLoadConfig_act_closeConfigLoadDirectory.invokeWithStringArg("true")
               }
           }
         }
         
         Rectangle {
           id: validButton
           width: buttonSelection.buttonWidth
           height: buttonSelection.buttonHeight
           color: ViaviStyle.colors.activeColor
           enabled: wizardLoadConfig_res_canLoad.value && wizardLoadConfig_res_loadButtonEnabled.value
           
           opacity: enabled ? ( mouseAreaValidButton.pressed ? 0.8 : 1 ) : 0.7
           
           visible: listview.current_idx_selected >= 0

           Text {
               color: VColor.cViaviColorWhite
               anchors.fill: parent
               text: wizardWindowManager_res_txtLoadSelectedFile.value.toUpperCase()
               horizontalAlignment: Text.AlignHCenter
               verticalAlignment:  Text.AlignVCenter
               font.pixelSize: buttonSelection.textSize
           }

           MouseArea {
               id: mouseAreaValidButton
               
               anchors.fill: parent
               onClicked: {
                  wizardLoadConfig_cfg_selectedFileIndex.value = listview.current_idx_selected
                  wizardLoadConfig_act_closeConfigLoadDirectory.invokeWithStringArg("false")
               }
           }
         }
         
         Rectangle {
           id: switchDirButton
           width: buttonSelection.buttonWidth
           height: buttonSelection.buttonHeight
           color: ViaviStyle.colors.activeColor
           
           property bool goUp: true
           property string goUpIconPath: "/acterna/storage/look-and-feel/generic/Wizard_Goto_Parent_Dir.png"
           property string goDownIconPath: "/acterna/storage/look-and-feel/generic/Wizard_Goto_Child_Dir.png"
           
           opacity: mouseAreaSwitchDirButton.pressed ? 0.8 : 1 

            Image {
               source: switchDirButton.goUp ? switchDirButton.goUpIconPath : switchDirButton.goDownIconPath
            
               anchors.fill: parent
               anchors.margins: 4
               
               fillMode: Image.PreserveAspectFit
               smooth: true
            }
           
           MouseArea {
               id: mouseAreaSwitchDirButton
               
               anchors.fill: parent
               
               onClicked: {
                  wizardLoadConfig_act_switchDirectory.invoke();
                  switchDirButton.goUp = !switchDirButton.goUp;
                  listview.current_idx_selected = 0
               }
           }
         } 
       }
   } 
}
