import QtQuick 2.3
import QtQuick.Layouts 1.2
import QtQuick.Controls 2.0
import "ViaviStyle"

AbstractButton{
    id: button

    property alias textHorizontalAlignment: textId.horizontalAlignment
    property string source: ViaviStyle.images.iconSettings
    font: ViaviStyle.layouts.tableFont

    contentItem: Rectangle{
        color: button.enabled ? button.pressed ? ViaviStyle.colors.checkedItemColor
                                               : ViaviStyle.colors.contentBackgroundColor
                                               : ViaviStyle.colors.disabledItemColor

        border.color: ViaviStyle.colors.activeColor
        border.width: ViaviStyle.layouts.borderSize * 3

        Text{
            id: textId

            anchors.top: parent.top
            anchors.bottom: parent.bottom
            anchors.left: parent.left
            anchors.right: icon.left
            anchors.leftMargin: ViaviStyle.layouts.largeMargin
            anchors.rightMargin: ViaviStyle.layouts.largeMargin

            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter

            text: button.text
            font: button.font
            elide: Text.ElideLeft
            color: button.pressed ? ViaviStyle.colors.activeColor : ViaviStyle.colors.mainInfoColor
        }

        FiberColorImage {
            id: icon

            anchors.top: parent.top
            anchors.bottom: parent.bottom
            anchors.right: parent.right
            anchors.rightMargin: ViaviStyle.layouts.largeMargin

            source: button.source

            color: ViaviStyle.colors.activeColor
            //button.pressed ? ViaviStyle.colors.activeItemTextColor: ViaviStyle.colors.activeColor

            fillMode: Image.PreserveAspectFit
            smooth: true
        }
    }
}

