import QtQuick 2.5
import QtQuick.Controls 2.0
import QtQuick.Layouts 1.2
import QtQml 2.2

import "ViaviStyle"

/*!
 * MouseArea that can provide a pop-up on long press. Popup is linked through longPressMenu. The popup needs to be a FiberPopup.
 * Signal beforePressAndHold can be used to call action needed before showing the popup.
 */
MouseArea {
    id: root
    property int longPressDuration: 2000
    property bool showAnimation: false
    property int animationDelay: 150

    property FiberPopup longPressMenu

    property int longPressHinterSize: 30

    signal beforePressAndHold()

//  No animation and no long press hinter as they needlessly impact performance on MTS4000
//    Item {
//        id: longPressHinter
//        anchors.top: parent.top
//        anchors.left: parent.left
//        visible: false

//        width: longPressHinterSize
//        height: longPressHinterSize
//        RadialGradient {
//            anchors.fill: parent
//            gradient: Gradient {
//                GradientStop { position: 0.0; color: '#FF7777FF' }
//                GradientStop { position: 1.0; color: '#00FF0000' }
//            }

//            horizontalOffset: -longPressHinterSize/2
//            verticalOffset: -longPressHinterSize/2
//        }
//    }

    onClicked: {
        mouse.accepted = false
        longPressAnimationTimer.stop()
    }

    onPressed: {
        if (showAnimation) {
            longPressAnimationTimer.start()
        }
    }

    onReleased: {
        finishAnimation()
    }

    onExited: {
        finishAnimation()
    }

    onCanceled: {
        finishAnimation()
    }

    onPressAndHold: {
        finishAnimation()
        beforePressAndHold()
        positionTargetToMouse()
        showMenu()
    }

    onPositionChanged: {
        positionTargetToMouse()
    }

    function positionTargetToMouse() {
//        animationRect.x = mouseX - animationRect.width/2
//        animationRect.y = mouseY - animationRect.height/2
        if(longPressMenu){
            var parentPox = mapToItem(longPressMenu.parent, mouseX, mouseY)
            longPressMenu.x = parentPox.x
            longPressMenu.y = parentPox.y
        }
    }

    function showMenu() {
        if(longPressMenu){
            longPressMenu.open()
        }
    }


    Timer {
        id: longPressAnimationTimer
        interval: animationDelay
        repeat: false
        onTriggered: {
            root.positionTargetToMouse()
//            animationRect.visible = true
//            timerAnimation.restart()
        }
    }

    function finishAnimation() {
//        animationRect.visible = false
//        timerAnimation.complete()
//        timerAnimation.stop()
        longPressAnimationTimer.stop()
    }

//  No animation and no long press hinter as they needlessly impact performance on MTS4000
//    Rectangle {
//        id: animationRect
//        property int rectSize: 40
//        width: rectSize
//        height: rectSize
//        radius: rectSize
//        visible: false
//        gradient: Gradient {
//            GradientStop { position: 0.0; color: 'red' }
//            GradientStop { position: 1.0; color: 'blue' }
//        }

//        Rectangle {
//            id: originCorner
//            color: 'blue'
//            anchors.verticalCenter: parent.top
//            anchors.horizontalCenter: parent.left
//            width: 10
//            height: 10
//            radius: 10
//        }

//        RotationAnimation {
//            id: timerAnimation
//            duration: longPressDuration
//            from: 0
//            to: 360
//            direction: RotationAnimation.Clockwise
//            loops: 1
//            target: animationRect
//        }
//    }
}
