import QtQuick 2.5
import "ViaviStyle"
import elf_plugin 1.0

Item {

    anchors.left: parent.left
    anchors.top: parent.top
    anchors.bottom: parent.bottom

    width: parent.width - keyboardUtils.widthRightColumn

    property var alternativeKeysModel

    property var minValue
    property var maxValue
    property var autoValue

    property bool dotIsAllowed: true


    ListModel{
        id: keysModel

        ListElement{
           name: "Min"
        }

        ListElement{
           name: "."
        }

        ListElement{
           name: "Max"
        }

        ListElement{
           name: "7"
        }

        ListElement{
           name: "8"
        }

        ListElement{
           name: "9"
        }

        ListElement{
           name: "4"
        }

        ListElement{
           name: "5"
        }

        ListElement{
           name: "6"
        }

        ListElement{
           name: "1"
        }

        ListElement{
           name: "2"
        }

        ListElement{
           name: "3"
        }

        ListElement{
           name: "0"
        }

        ListElement{
           name: "+/-"
        }

        ListElement{
           name: ""
        }

    }

    readonly property bool minKeyVisible: minValue !== undefined
    readonly property bool maxKeyVisible: maxValue !== undefined
    readonly property bool plusMinusKeyVisible: !(minValue !== undefined && maxValue !== undefined
                                                   && minValue * maxValue >= 0)
    readonly property int minKeyIndex: 0
    readonly property int dotKeyIndex: 1
    readonly property int maxKeyIndex: 2
    readonly property int plusMinusKeyIndex: 13

    onMinKeyVisibleChanged: keysModel.setProperty(minKeyIndex, "name", minKeyVisible ? "Min" : "")
    onMaxKeyVisibleChanged: keysModel.setProperty(maxKeyIndex, "name", maxKeyVisible ? "Max" : "")
    onPlusMinusKeyVisibleChanged: keysModel.setProperty(plusMinusKeyIndex, "name", plusMinusKeyVisible ? "+/-" : "")
    onDotIsAllowedChanged: keysModel.setProperty(dotKeyIndex, "name", dotIsAllowed ? "." : "")

    GridView {
        id: numericalGrid

        anchors.fill: parent

        cellWidth: parent.width / 3
        cellHeight:  parent.height / 5

        model: alternativeKeysModel !== undefined ? alternativeKeysModel : keysModel

        boundsBehavior: Flickable.StopAtBounds

        delegate: KeyboardButton {

            buttonWidth: numericalGrid.cellWidth
            buttonHeight: numericalGrid.cellHeight
            buttonLabel: model.name
            buttonType: model.name.length === 1 ? keyboardUtils.buttonTypeNumerical : keyboardUtils.buttonTypeCustom
            buttonEnabled: model.name.length !== 0
        }
    }

    Component.onCompleted: {
        keysModel.setProperty(minKeyIndex, "name", minKeyVisible ? "Min" : "")
        keysModel.setProperty(maxKeyIndex, "name", maxKeyVisible ? "Max" : "")
        keysModel.setProperty(plusMinusKeyIndex, "name", plusMinusKeyVisible ? "+/-" : "")
    }
}

