import QtQuick 2.5
import "ViaviStyle"


KeyboardButton {

    property bool buttonHasPicture      : false
    property string buttonPicturePath   : ""
    property bool buttonIsCommon        : false

    buttonWidth: keyboardUtils.buttonWidthCustom
    buttonBackgroundColor: buttonPressed ? ViaviStyle.colors.activeColor :
                           buttonIsCommon ? ViaviStyle.colors.keyboardButtonCustomColor : ViaviStyle.colors.contentBackgroundColor
    buttonType: keyboardUtils.buttonTypeCustom
    buttonLabelVisible: buttonEnabled && !buttonHasPicture

    FiberColorImage {

        visible: buttonHasPicture

        width: parent.width * 0.4
        height: parent.height * 0.6

        opacity: buttonEnabled ? 1.0 : 0.3

        anchors.centerIn: parent

        source: buttonPicturePath
        fillMode: Image.PreserveAspectFit
        smooth: true

        color: buttonPressed ? ViaviStyle.colors.activeItemTextColor : ViaviStyle.colors.activeColor
    }
}



