import QtQuick 2.5
import "ViaviStyle"
import elf_plugin 1.0

Item {
    anchors.left: parent.left
    anchors.top: parent.top

    width: parent.width - keyboardUtils.widthRightColumn
    height: parent.height - keyboardUtils.heightBottomRow

    property alias keysModel: secondPageGrid.model

    GridView {
        id: secondPageGrid

        anchors.centerIn: parent

        /* make the 2nd page buttons smaller */
        width: parent.width * 0.7
        height: parent.height

        cellWidth:  width / 4
        cellHeight: height / 4

        boundsBehavior: Flickable.StopAtBounds

        delegate: KeyboardButton {

            buttonWidth: secondPageGrid.cellWidth
            buttonHeight: secondPageGrid.cellHeight
            buttonLabel: model.name
            buttonType: keyboardUtils.buttonType2ndPage
        }
    }
}

