import 'ViaviVirtualKeyboard'

KeyboardButton {
    property var text: []
    property bool isKeyType: true

    //If symbols should be available also on partial keyboards (i.e. keyboard type different from cComplete_Keyboard).
    //In Fiber Optics a partial keyboard is one that doesn't show all possible symbols, for example for restricting the file names the user might choose.
    //Levels significance ( https://en.wikipedia.org/wiki/ISO/IEC_9995#Levels_(%E2%80%9Cunshifted%E2%80%9D_%E2%80%9Cshifted%E2%80%9D,_%E2%80%9CAltGr%E2%80%9D) ):
    //1 - symbols on the default keyboard (i.e. no Caps Lock/shift, any modifiers or dead keys active),
    //2 - Caps Lock active
    //3 and beyond - modifiers such AltGr. Not currently implemented/defined.
    property bool showInPartialLevel1: true
    property bool showInPartialLevel2: true

    buttonLabel: getLabel()
    buttonEnabled: InputContext.capsLock ? (InputContext.fullLevel2 || showInPartialLevel2) :
                                           (InputContext.fullLevel1 || showInPartialLevel1)

    function getLabel() {
        if (InputContext.capsLock) {
            return text.length > 1 ? text[1] : text[0].toUpperCase()
        }
        else {
            return text[0]
        }
    }
}
