﻿import QtQuick 2.3
import QtQuick.Controls 2.0
import "ViaviStyle"

AbstractButton{
    id: button

    property alias source: image.source
    property alias color: image.color
    property bool isChecked: false

    width: ViaviStyle.layouts.imageButtonHeight
    height: ViaviStyle.layouts.imageButtonHeight

    contentItem:
    FiberColorImage{
        id: image

        width: parent.width - button.leftPadding - button.rightPadding
        height: parent.height - button.topPadding - button.bottomPadding

        color: button.enabled
                    ? button.pressed ? ViaviStyle.colors.selectedColor :
                    button.isChecked ? ViaviStyle.colors.checkedItemColor :ViaviStyle.colors.activeColor
                    : ViaviStyle.colors.disabledItemColor
    }
}
