import QtQuick 2.3
import QtQuick.Layouts 1.1
import "ViaviStyle"

Rectangle{
    id: fcompRoot

    readonly property real scaleFactorFCompTabRow: ViaviStyle.layouts.isSmallScreen ? 0.70 : 1
    readonly property real scaleFactorFCompTableCellHeight: 1.5

    property real maxTableDataCellHeight: ( genericTableFComp.height - genericTableFComp.titleCellHeight
                                           - genericTableFComp.headerCellHeight ) / generictable_res_genericTableNbLineData.value

    property int fixTableTitleHeight: ViaviStyle.layouts.imageButtonHeight + 2 * ViaviStyle.layouts.smallMargin
    property int fixTableDefaultVisibleLines: 3
    property int fixTableHeaderVisibleLines: 2
    property int fixTableDefaultHeight: (fixTableHeaderVisibleLines + fixTableDefaultVisibleLines) * ViaviStyle.layouts.genericTableLineHeight
                                        + fixTableTitleHeight + ViaviStyle.layouts.smallMargin //title + header + actual lines + bottom margin

    property bool isProcessView: fcomp_res_view.value === fcomp_res_view.enums.efvProc
    property bool isIlOrlSummaryView: fcomp_res_view.value === fcomp_res_view.enums.efvIlOrl
    property bool isLoopbackMode: fcomp_res_isLoopbackModeEnabled.value

    anchors.fill: parent

    color: ViaviStyle.colors.pageBackgroundColor

    ColumnLayout {
        id: mainColumn

        anchors.left: parent.left
        anchors.right: parent.right
        anchors.leftMargin : ViaviStyle.layouts.largeMargin
        anchors.rightMargin : ViaviStyle.layouts.largeMargin

        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.topMargin : ViaviStyle.layouts.mediumMargin
        anchors.bottomMargin : ViaviStyle.layouts.mediumMargin

        spacing: ViaviStyle.layouts.mediumMargin

        Item {
            height: ViaviStyle.layouts.buttonHeight * fcompRoot.scaleFactorFCompTabRow - mainColumn.spacing
            Layout.fillWidth: true

            FCompTabRow {
                anchors.topMargin: - mainColumn.anchors.topMargin
                anchors.bottomMargin: - mainColumn.spacing
                anchors.fill: parent
            }
        }

        SummaryInfo {
            id: summaryFComp

            visible: !status_res_schematicEnabled.value
            Layout.fillWidth: true
            Layout.preferredHeight: summaryFComp.height
        }

        MiniSlm {
            id: miniSlmFcomp

            visible: status_res_schematicEnabled.value
            Layout.fillWidth: true
            Layout.preferredHeight: summaryFComp.height

            selectedItemIndex: schematic_cfg_slmCurrentEvent.value

            firstLastFromTrace: false
            firstItemDistance: schematicFcomp.firstItemDistance
            lastItemDistance:  schematicFcomp.lastItemDistance
        }

        FixSynoptic {
            id: synopticFComp
            
            visible: isProcessView && !status_res_schematicEnabled.value
            Layout.fillWidth: true
            Layout.fillHeight: true

            onVisibleChanged: {

            }
        }

        Loader {
            source: 'FixSynoptic_TestModule.qml'
            id: testModule
            
            visible: synoptic_res_testModuleEnabled.value && synopticFComp.testModuleVisible

            active: synoptic_res_testModuleEnabled.value && synopticFComp.testModuleVisible
            Layout.fillWidth: true
            Layout.preferredHeight: fixTableDefaultHeight
        }

        GenericTable {
            id: genericTableFComp

            visible: !( isProcessView && !fcomp_res_isReferenceTableSelected.value )
                     && !status_res_schematicEnabled.value && !testModule.visible
            Layout.fillWidth: true
            Layout.preferredHeight: fixTableDefaultHeight
            Layout.fillHeight: synopticFComp.visible ? false: true

            titleCellHeight: ( fcomp_res_isCableTableSelected.value || fcomp_res_isReferenceTableSelected.value )
                             ? fixTableTitleHeight
                             : ViaviStyle.layouts.genericTableLineHeight
            titleFont: ( fcomp_res_isCableTableSelected.value || fcomp_res_isReferenceTableSelected.value )
                        ? ViaviStyle.layouts.veryLargeFont
                         : ViaviStyle.layouts.tableTitleFont

            emptyCellText: isIlOrlSummaryView ? "": "--"

            headerCellHeight: isIlOrlSummaryView ? ViaviStyle.layouts.genericTableLineHeight * fcompRoot.scaleFactorFCompTableCellHeight
                                                 : ViaviStyle.layouts.genericTableLineHeight
            dataCellHeight: isIlOrlSummaryView ? Math.min( ViaviStyle.layouts.genericTableLineHeight * fcompRoot.scaleFactorFCompTableCellHeight
                                                , fcompRoot.maxTableDataCellHeight )
                                               : ViaviStyle.layouts.genericTableLineHeight
                                               
            isInfo_Button_Available: isIlOrlSummaryView && !isLoopbackMode

            FCompCableTableLineOverlay{
                visible: fcomp_res_isCableTableSelected.value

                anchors.left: parent.left
                anchors.right : parent.right
                anchors.top: parent.top
                anchors.topMargin: ViaviStyle.layouts.mediumMargin
            }

            FCompReferenceTableOverlay{
                visible: fcomp_res_isReferenceTableSelected.value

                anchors.left: parent.left
                anchors.right : parent.right
                anchors.top: parent.top
                anchors.topMargin: ViaviStyle.layouts.mediumMargin
            }

            Item{
                id: customDialogPlaceHolder
                visible: fcomp_res_isReferenceTableSelected.value

                anchors.fill: parent

                Connections{
                    target: genericTableFComp
                    function onXChanged() {
                    	if(customDialogPlaceHolder.visible) 
                    		customDialogPlaceHolder.updateCustomDialogPosition()
                    }
                    function onYChanged() {
                    	if(customDialogPlaceHolder.visible) 
                    		customDialogPlaceHolder.updateCustomDialogPosition()
                    }
                }
                Connections{
                    target: mainColumn
                    function onXChanged() {
                    	if(customDialogPlaceHolder.visible) 
                    		customDialogPlaceHolder.updateCustomDialogPosition()
                    }
                    function onYChanged() {
                    	if(customDialogPlaceHolder.visible) 
                    		customDialogPlaceHolder.updateCustomDialogPosition()
                    }
                }

                onWidthChanged: if(visible) dialog_cfg_customWidth.value = width
                onHeightChanged: if(visible) dialog_cfg_customHeight.value = height
                onVisibleChanged: {
                    if(visible){
                        updateCustomDialogPosition()
                        dialog_cfg_customWidth.value = width
                        dialog_cfg_customHeight.value = height
                    }
                }

                function updateCustomDialogPosition(){
                    var pos = mapToItem(fiberMainPage, 0, 0)
                    dialog_cfg_customX.value = pos.x
                    dialog_cfg_customY.value = pos.y
                }
            }
        }

        Rectangle {
            visible: isProcessView && !fcomp_res_isReferenceTableSelected.value
                     && !mappingMPO.visible && !testModule.visible
            Layout.fillWidth: true
            Layout.preferredHeight: fixTableDefaultHeight
            color: ViaviStyle.colors.pageBackgroundColor
        }

        FCompMPOPolarity {
            id: mappingMPO
            visible: isProcessView && !fcomp_res_isReferenceTableSelected.value
                        && polarity_res_isSwitchReady.value
            Layout.fillWidth: true
            Layout.preferredHeight: fixTableDefaultHeight
        }

        Schematic {
            id: schematicFcomp
            Layout.fillWidth: true

            height: ViaviStyle.layouts.schematicHeight
            visible: status_res_schematicEnabled.value
            detailModeAlwaysOn: true
        }

        Item {
            Layout.fillWidth: true

            visible: status_res_eventDetailEnabled.value
            Layout.fillHeight: true

            Loader {
                id: eventFComp
                anchors.fill: parent

                source: ViaviStyle.layouts.isSmallScreen ?
                            "EventInfoOptimeterLayout.qml" : "EventInfo.qml"
            }
        }
    }
}
