<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2014. All rights reserved.
// *********************************************************
namespace app\util;

use app\admin\SMTLanguage;

class SMTUnit
{      
    const CENTIMETER = "cm";
    const METER = "m";
    const KILOMETER = "km";
    const FEET = "ft";
    const INCHES = "in";
    const MILES = "mi";
    const YARDS = "yd";

    /**
     * 
     * @param float $value
     * @param String $toUnit ( default self::METER )
     * @param string $fromUnit ( default self::METER)
     * @return float
     */
    public static function convertToUnit( $value, $toUnit=self::METER, $fromUnit=self::METER )
    {
        return self::fromKernel( self::toKernel( $value, $fromUnit), $toUnit );
    }
    
    /**
     * Format length unit and choose the best range according to the length value
     * 
     * @param float $value
     * @param String $toUnit ( default self::METER )
     * @param string $fromUnit ( default self::METER)
     * @return float
     */
    public static function formatToUnitWithBestRange( $value, $toUnit=self::METER, $fromUnit=self::METER )
    {
        $digits = 0;
        $kernelValue = self::toKernel( $value, $fromUnit);
        if ( $kernelValue > 10000.0 )
        {
            if ( $toUnit == self::METER || $toUnit == self::CENTIMETER ) $toUnit = self::KILOMETER;
            else if ( $toUnit == self::FEET || $toUnit == self::INCHES ) $toUnit = self::MILES;
            $digits = 3;
        }
        else
        {
            if ( $toUnit=self::KILOMETER ) $toUnit = self::METER;
            else if ( $toUnit == self::MILES ) $toUnit = self::FEET;
            $digits = 0;
        }
        return number_format( self::fromKernel( $kernelValue, $toUnit ), $digits, SMTLanguage::isFrenchLanguage()? ',':'.', SMTLanguage::isFrenchLanguage()? ' ' : ',' ).$toUnit;
    }
    
    /**
     * 
     * @param float $value
     * @param unknown $fromUnit
     * @return number
     */
    private static function toKernel( $value, $fromUnit  )
    {
        switch ( $fromUnit )
        {
        	case self::CENTIMETER:
        	    $value = $value* 0.01;
        		break;
        	case self::METER:
        		break;
        	case self::KILOMETER:
        	    $value = $value*1000.0;
        		break;
        	case self::FEET:
        	    $value = $value*0.3048;
        		break;
        	case self::INCHES:
        	    $value = $value*0.0254;
        		break;
        	case self::MILES:
        	    $value = $value*1609.344;
        		break;
        	case self::YARDS:
        	    $value = $value*0.9144;        		
        		break;
        }
        return $value;
    }
    
    /**
     * 
     * @param float $value
     * @param unknown $toUnit
     * @return float
     */
    private static function fromKernel( $value, $toUnit )
    {
        switch ( $toUnit )
        {
        	case self::CENTIMETER:
        		$value = $value* 100.0;
        		break;
        	case self::METER:
        		break;
        	case self::KILOMETER:
        		$value = $value*0.001;
        		break;
        	case self::FEET:
        		$value = $value*3.280839;
        		break;
        	case self::INCHES:
        		$value = $value*39.370078;
        		break;
        	case self::MILES:
        		$value = $value*0.00062137;
        		break;
        	case self::YARDS:
        		$value = $value*1.0936132;
        		break;
        }
        return $value;
    } 
}
?>