<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\serviceshelper\monitoring;

use app\util\SMTUtil;

use app\events\operations\SMTOperationEventDto;

use app\events\operations\SMTIOperationEventDto;

/**
 * Test on demand dto
 * 
 * @author Sylvain Desplat
 *
 */
class SMTTestOnDemandEventDto extends SMTOperationEventDto implements SMTIOperationEventDto
{       
    /**
     * @var string
     */    
    protected $testId;
       
    
    function getTestId()
    {
    	return $this->testId;
    }
    
    function setTestId( $testId )
    {
    	$this->testId = SMTUtil::convertToInt($testId);
    }    
    
    function setStatus( $status )
    {
    	if ( $this->isValidTestStatus( $status ) )
    	{
    		$this->status = $status;
    		$this->setLocalizedMessage( self::decodeMessage( $status ) );    		
    	}
    	else
    	{
    		throw new \InvalidArgumentException( MSG_ERROR_INVALID_OPERATION_STATUS );
    	}    	
    }    
    
    /**
     * Whether the status given is a test status
     *
     * @param string $code mesure status
     *
     * @return boolean
     */
    public function isValidTestStatus( $code )
    {
    	return self::isOperationStatus($code);
    }    
    
    /**
     * Translates status code. If the code is not found, returns an empty string.
     * 
     * @param string $code The status code to translate
     * 
     * @return string the status message or an empty string if the status couldn't be found.
     */
    public static function decodeMessage( $code )
    {
        $message = MSG_ERROR_TEST_FAILED;
        
        switch( $code )
        {		    
		    case SMTOperationEventDto::BAD_TIMESLOT:
		    	$message = MSG_ERROR_TEST_BAD_TIMESLOT;
		    	break;
		    case SMTOperationEventDto::NO_PROGRAMMED:
		    	$message = MSG_ERROR_TEST_NOT_PROGRAMMED;
		    	break;
		    case SMTOperationEventDto::FAILED:
		    	$message = MSG_ERROR_TEST_FAILED;
		    	break;	    	    		    
            default:
                $message = SMTOperationEventDto::decodeMessage($code);
                break;
        }
        return $message;
    }
    
    /**
     * Generate the test on demand identifier.
     * Only one test on demand can be running.
     *
     * @return string the test on demand identifier.
     */
    public static function generateTestOnDemandOperationId()
    {
    	return SMTOperationEventDto::TEST_ON_DEMAND.str_replace( " ", "_", microtime(false) );
    }    
    
    /**
     * Serialize as Json data the user object.<br>
     *
     * @return $objectProperties the object properties serialized as a Json string.
     */
    function getJsonData()
    {
    	$objectProperties = get_object_vars($this);
    	$this->serializeObjectAsJsonData( $objectProperties );
    	return $objectProperties;
    }
    
    /**
     * Returns Dto class name.
     *
     * @return string the dtop class name
     */
    function getDtoClassName()
    {
    	return get_class();
    }        
    
    /**
     * Returns the dto class name.
     *
     * @return the dto class name.
     */
    public static function getClass()
    {
    	return __CLASS__;
    }    
    
    /**
     * Create the Dto from a Json Dto in an array
     *
     * @param array $json_array json data in an array
     *
     * @return \app\services\monitoring\SMTLinkTestDto
     */
    static function getInstance( array &$json_array )
    {
    	return self::forge( get_class(), $json_array );
    }    
}

?>