<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\serviceshelper\alarm;

/**
 * Wraps tOtu_Alarm_Severity
 * 
 * @author Sylvain Desplat
 */
class SMTOtuAlarmSeverity
{
    const OTU_SEVERITY_INFO = "INFO";
    const OTU_SEVERITY_CLEAR = "CLEAR";
    const OTU_SEVERITY_WARNING = "WARNING";
    const OTU_SEVERITY_MINOR = "MINOR";
    const OTU_SEVERITY_MAJOR = "MAJOR";
    const OTU_SEVERITY_CRITICAL = "CRITICAL";
    const OTU_SEVERITY_UNKNOWN = "UNKNOWN";
    
    /**
     * Whether the given severity is due to an alarm transition in OTU
     * @param string $otuSeverity
     * @return boolean
     */
    public static function hasSeverityTransition( $otuSeverity )    
    {
        return ( ($otuSeverity != self::OTU_SEVERITY_INFO) && ($otuSeverity != self::OTU_SEVERITY_UNKNOWN) );
    }
    
    /**
     * Whether the given severity is due to an alarm transition in OTU 
     * and whether the new state is not a clear state
     * 
     * @param string $otuSeverity
     * 
     * @return boolean
     */
    public static function hasSeverityTransitionAndNotCleared( $otuSeverity )
    {
    	return self::hasSeverityTransition( $otuSeverity ) && ($otuSeverity != SMTOtuAlarmSeverity::OTU_SEVERITY_CLEAR);
    }    
}
?>