<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\serviceshelper\alarm;

use app\util\SMTException;

/**
 * Alarm exceptions
 * 
 * @author Sylvain Desplat
 */
class SMTAlarmException extends SMTException
{
    const ERROR_INVALID_ALARM_NAME = "ERROR_INVALID_ALARM_NAME";
    const ERROR_ALARM_FETCH_FAILED = "ERROR_ALARM_FETCH_FAILED";
    const ERROR_ALARM_RETRIEVAL_FAILED = "ERROR_ALARM_NOT_FOUND";
    const ERROR_DELETE_OPTICAL_ALARM_FAILED = "ERROR_DELETE_OPTICAL_ALARM_FAILED";
            
    /**
     *
     * @param string $code alarm error code
     * @param string $message detailed message
     */    
    function __construct( $code = NULL, $message = NULL )
    {
    	parent::__construct( $code, $message );
    }
    
    /**
     * Get error codes label for tracing without error codes.
     *
     * @return string
     */
    public function getErrorLabel()
    {
    	return $this->getErrorCode();
    }
    
    /**
     * Translates exception error code
     * 
     * @param string $code The exception error code
     * 
     * @return string the exception message
     */
    public function decodeMessage( $code )
    {
        $errorMessage = MSG_ERROR_ALARM_UNDEFINED;
        
        switch( $code )
        {
            case self::ERROR_INVALID_ALARM_NAME:
                $errorMessage = MSG_ERROR_INVALID_ALARM_NAME;
                break;  
            case self::ERROR_ALARM_RETRIEVAL_FAILED:
            case self::ERROR_ALARM_FETCH_FAILED:
            	$errorMessage = MSG_ERROR_ALARM_FETCH_FAILED;
            	break;                                
            case self::ERROR_DELETE_OPTICAL_ALARM_FAILED:
                $errorMessage = MSG_ERROR_DELETE_OPTICAL_ALARM_FAILED;
                break;
            default:
                break;
        }
        return $errorMessage;
    }
}

?>