<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of VIAVI Solutions
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from VIAVI Solutions
// Copyright VIAVI Solutions 2018. All rights reserved.
// *********************************************************
namespace app\services\setup;

use app\sharedmemory\SMTIMemorySupport;
use app\sharedmemory\SMTMemoryManager;
use app\util\SMTDto;

/**
 * Dto with OTU external switch infos
 * 
 * @author Sylvain Desplat
 */
class SMTOsxDto extends SMTDto implements SMTIMemorySupport
{
    /**
     * Switch index: 0 pour interne, 31 pour OSX distributeur...
     */
    protected $index;
    /**
     * @var string
     */
	protected $ports;
	/**
	 * 
	 * @var string
	 */
	protected $description = "";

	public function setIndex( $index )
	{
		$this->index = $index;
	}
	
	public function getIndex()
	{
		return $this->index;
	}
	
	public function setPorts( $ports )
	{
		$this->ports= $ports;
	}
	
	public function getPorts()
	{
		return $this->ports;
	}

	public function setDescription( $description)
	{
		$this->description= $description;
	}
	
	public function getDescription()
	{
		return $this->description;
	}
	
    /**
     * Serialize as Json data the user object.<br>
     *
     * @return $objectProperties the object properties serialized as a Json string.
     */
    function getJsonData()
    {
    	$objectProperties = get_object_vars($this);
    	$this->serializeObjectAsJsonData( $objectProperties );
    	return $objectProperties;
    }
    
    /**
     * Identifier of OSX
     *
     * @return string
     */
    public function getId()
    {
    	return $this->index;
    }
    
    /**
     * Save Dto in shared memory
     *
     * @throws SMTAPCMemoryException
     */
    public function save()
    {
    	SMTMemoryManager::saveDto( $this );
    }
    
    /**
     * Delete Dto from shared memory
     *
     * @throws SMTAPCMemoryException
     */
    public function delete()
    {
    	SMTMemoryManager::deleteDto( $this );
    }	
    
    /**
     * Returns Dto class name.
     *
     * @return string the dtop class name
     */
    function getDtoClassName()
    {
    	return get_class();
    }
    
    
    /**
     * Returns the dto class name.
     *
     * @return the dto class name.
     */
    public static function getClass()
    {
    	return __CLASS__;
    }
    
    /**
     * Otu OTDR module cache is never obsolete: it must not be purged
     *
     * @return FALSE
     */
    public function isObsolete()
    {
    	return FALSE;
    }
    
    /**
     * No obsolescence for those data: returns current time.
     *
     * @see isObsolete()
     * @return number Timestamp of the last APC memory access (used to handle obsolescence of dtos in cache)
     */
    public function getLastAccess()
    {
    	return microtime(TRUE);
    }
    
    /**
     * No obsolescence for those data: do nothing
     *
     * @see isObsolete()
     *
     */
    public function touchAccess()
    {
    }
}
?>