<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of VIAVI Solutions
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from VIAVI Solutions
// Copyright VIAVI Solutions 2017. All rights reserved.
// *********************************************************
namespace app\services\setup;

use app\util\SMTRwDto;

/**
 * 
 * @author Sylvain Desplat
 */
class SMTOnmsiServerDto extends SMTRwDto
{
    /**
     * 
     * @var main route server
     */
	protected $mainRouteServerName;
	
	/**
	 *
	 * @var backup route server
	 */
	protected $backupRouteServerName;
	
	/**
	 *
	 * @var main route server Ip
	 */
	protected $mainRouteServerIp;
	
	/**
	 *
	 * @var backup route server Ip
	 */
	protected $backupRouteServerIp;
	
	/**
	 *
	 * @var boolean whether this is the active server
	 */
	protected $isActive;
	
	/**
	 *
	 * @var int server index ( 1 or 2)
	 */
	protected $index;
	
	/**
	 * @param string $mainRoute
	 */
	public function setMainRouteServerName( $mainRoute)
	{
		$this->mainRouteServerName= $mainRoute;
	}
	
	/**
	 * @param string $backupRoute
	 */
	public function setBackupRouteServerName( $backupRoute)
	{
		$this->backupRouteServerName= $backupRoute;
	}
	
	/**
	 * @param string $mainRouteIp
	 */
	public function setMainRouteServerIp( $mainRouteIp)
	{
		$this->mainRouteServerIp= $mainRouteIp;
	}
	
	/**
	 * @param string $backupRouteIp
	 */
	public function setBackupRouteServerIp( $backupRouteIp)
	{
		$this->backupRouteServerIp= $backupRouteIp;
	}
	
	/**
	 * @param boolean $active
	 */
	public function setIsActive( $active)
	{
		$this->isActive= $active;
	}
	
	/**
	 * @param boolean $active
	 */
	public function isActive()
	{
		return $this->isActive;
	}
	
	/**
	 * @param int $index
	 */
	public function setIndex( $index)
	{
		$this->index= $index;
	}
	
	public function hasBackupRoute()
	{
		return ($this->backupRouteServerIp != "");
	}
	
	/**
	 * Serialize as Json data the user object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json string.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties );
		return $objectProperties;
	}

	/**
	 * Returns Dto class name.
	 *
	 * @return string the dto class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}
	
	/**
	 * Create the Dto from a Json Dto in an array
	 *
	 * @param array $json_array json data in an array
	 *
	 * @return \app\services\setup\SMTOnmsiServerDto
	 */
	static function getInstance( array &$json_array )
	{
		return self::forge( get_class(), $json_array );
	}
}


?>