<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\services\alarm;

use app\serviceshelper\alarm\SMTAlarmEventTypeCode;

use app\util\SMTUtil;

use app\util\SMTInvalidValueException;

/**
 * Optical alarm Dto (limited to attenuation alarm) 
 * 
 * @author Sylvain Desplat
 */
abstract class SMTOpticalAlarmDto extends SMTAlarmDto
{
    /**
     * @var integer
     */
    protected $testId;        
    
    /**
     *
     * @param integer $testId
     */
    public function setTestId( $testId )
    {
        if ( !isset( $testId) || $testId === NULL || !SMTUtil::isInt( $testId ) )
        {
        	throw new SMTInvalidValueException( SMTInvalidValueException::INVALID_VALUE, NULL, "testId", $testId );
        }
    	$this->testId = intval( $testId );
    }
    /**
     *
     * @return integer
     */
    public function getTestId()
    {
    	return $this->testId;
    }

    /**
     * Alarm type
     *
     * @return string
     */
    public function getAlarmType()
    {
    	return SMTAlarmEventTypeCode::OTU_ALARM_EVENT_TYPE_QUALITY_OF_SERVICE_ALARM;
    }
    
    /**
     * Serialize as Json data the user object.<br>
     *
     * @return $objectProperties the object properties serialized as a Json string.
     */
    function getJsonData()
    {
    	$objectProperties = get_object_vars($this);
    	$this->serializeObjectAsJsonData( $objectProperties );
    	return $objectProperties;
    }
    
    /**
     * Returns Dto class name.
     *
     * @return string the dtop class name
     */
    function getDtoClassName()
    {
    	return get_class();
    }
}



?>